﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace Siger.WeComApi.Core.Enum.ModuleEnum
{
    /// <summary>
    /// qms module, start from 9000000
    /// </summary>
    public enum QMSEnum
    {
        [Description("传感器已存在")]
        SensorExist = 9200000,
        [Description("传感器类型不存在")]
        SensorTypeNotExist,
        [Description("设备编号不存在")]
        MachineNotExist,
        [Description("标定周期单位无效")]
        CycleUnitNotExist,
        [Description("记录所在状态无法删除")]
        DetailCanNotDelete,
        [Description("记录所在状态无法修改")]
        DetailCanNotModify,
        [Description("传感器不存在")]
        SensorNotExist,
        [Description("当前设备没有绑定工位")]
        MachineNoStation,
        [Description("标定人不存在")]
        MarkUserValid,
        [Description("非当前传感器标定人")]
        NotMarkUser,
        [Description("Token无效")]
        TokenValid,
        [Description("当前无法修改")]
        CannotModify,
        [Description("模板文件不存在")]
        TemplateValid,
        [Description("该类型已被占用")]
        SensorTypeUsed,
        [Description("请填写查询条件")]
        SearchConditionInvalid,
        [Description("顺序已存在")]
        StepExits,
    }

    public enum DataTypeStatus
    {
        /// <summary>
        /// 计数
        /// </summary>
        [Description("计数")]
        NumType = 1,

        /// <summary>
        /// 计值
        /// </summary>
        [Description("计值")]
        ValType = 2
    }

    /// <summary>
    /// 填值打勾
    /// </summary>
    public enum ValueTypeStatus
    {
        [Description("打钩")]
        O = 1,

        [Description("填值")]
        V = 2
    }

    public enum SensorFileType
    {
        [Description("标定模板")]
        Template,

        [Description("标定文件")]
        File,

        [Description("验证模板")]
        Validation,

        [Description("验证文件")]
        ValidationFile,
        [Description("历史分析文件")]
        HistoryFile,
    }
    public enum SensorStatus
    {
        [Description("未设置")]
        NoSet = 1,

        [Description("待标定")]
        WaitMark,

        [Description("标定中")]
        Marking,

        [Description("正常")]
        Normal,

        [Description("逾期")]
        OverDue,
        [Description("期中校验")]
        Verification,
    }
    public enum SensorResult
    {
        [Description("默认")]
        Default = 0,
        [Description("待审核")]
        WaitAudit = 1,

        [Description("未通过")]
        NotPass,

        [Description("通过")]
        Pass,

        [Description("审核中")]
        Audit,

        [Description("待审核")]
        SecondWaitAudit,
    }

    public enum CycleUnit
    {
        [Description("小时")]
        Hour = 1,
        [Description("天")]
        Day,
        [Description("月")]
        Mounth
    }
    /// <summary>
    /// 
    /// </summary>
    public enum ReworkDataType
    {
        [Description("返工")]
        Rework =1,
        [Description("报废")]
        Waste =2
    }

    /// <summary>
    /// 送检检验状态
    /// </summary>
    public enum SendCheckStatus
    {
        [Description("待接收")]//原 待检测
        Testing = 1,        
        [Description("检测完成")]
        Completed = 2,
        [Description("待检验")]
        Recieved = 3,
        [Description("检验中")]
        Checking = 4
    }

    public enum CheckTypeCount
    {
        [Description("首件")]
        FirstArticle=1,
        [Description("自检")]
        SelfTest,
        [Description("巡检")]
        OnSiteInspection,
        [Description("完工检")]
        CompletionInspection
    }
    public enum AcquisitionModeEnum
    {
        [Description("人工录入")]
        ManualInput = 1
    }
    public enum AcquisitionEnum
    {
        [Description("USB")]
        USB = 1
    }

    public enum TraceFileType
    {
        [Description("图片")]
        Image = 1,
        [Description("附件")]
        File = 2
    }

    public enum ProblemType
    {
        [Description("待处理")]
        Wait=1,
        [Description("处理中")]
        Hand,
        [Description("已完成")]
        Complete
    }

    /// <summary>
    /// QMSBI数分接口类型
    /// </summary>
    public enum QmsBIInterfaceType
    {
        /// <summary>
        /// I-MR图
        /// </summary>
        [Description("ActivatePlotControl")]
        IMR_Plot = 1,
        /// <summary>
        /// I-MR图
        /// </summary>
        [Description("ActivatePlotMRControl")]
        IMR_PlotMR,
        /// <summary>
        /// XBar控制图
        /// </summary>
        [Description("ActivatePlotXbarControl")]
        XBarR_Plot,
        /// <summary>
        /// XBar-R控制图
        /// </summary>
        [Description("ActivatePlotXbarMRControl ")]
        XBarR_MRPlot,
        [Description("ActivatePlotPControl")]
        PlotP,
        [Description("ActivatePlotUControl")]
        PlotU,
        /// <summary>
        /// 时间序列
        /// </summary>
        [Description("ActivatePlotTS")]
        TimeSeries,
        /// <summary>
        /// 能力直方图
        /// </summary>
        [Description("ActivatePlotPpk")]
        LiuHeYi_ActivatePlotPpk,
        /// <summary>
        /// 正态概率图
        /// </summary>
        [Description("ActivatePlotProb")]
        LiuHeYi_ActivatePlotProb,
        /// <summary>
        /// 最后25个子组
        /// </summary>
        [Description("ActivatePlotScatterGroup")]
        LiuHeYi_ActivateScatterGroup,
        /// <summary>
        /// 能力图
        /// </summary>
        [Description("ActivatePlotCpk")]
        LiuHeYi_ActivatePlotCpk,
        /// <summary>
        /// SPC统计
        /// </summary>
        [Description("ActivatePlotPpk")]
        SPC_Statistics,
        /// <summary>
        /// 相关性分析
        /// </summary>
        [Description("ActivatePlotCorr")]
        Correlation,
        /// <summary>
        /// 检验项 相关性分析2.0
        /// </summary>
        [Description("RelationAnalysis")]
        RelationAnalysis
    }

    /// <summary>
    /// 进料检验结果类型
    /// </summary>
    public enum IncomingMaterialType
    {
        [Description("合格")]
        Qalified = 1,
        [Description("返工-已删除")]
        Rework,
        [Description("让步接收")]
        ConcessionReception,
        [Description("拒收")]
        Rejection,
    }

    /// <summary>
    /// 送检检验结果类型
    /// </summary>
    public enum SendTestType
    {
        [Description("合格")]
        Qalified = 1,
        [Description("偏差放行")]
        DeviationRelease,
        [Description("不合格")]
        Unqualified,
    }

    /// <summary>
    /// 检验类型
    /// </summary>
    public enum CheckType
    {
        [Description("首检")]
        FirstCheck = 1,
        [Description("抽检")]
        RandomCheck,
        [Description("末检")]
        LastCheck,
        [Description("二级件校对")]
        PartsCheck,
        [Description("首件")]
        FirstPartCheck,
        [Description("SPC检查")]
        SPCCheck,
        [Description("其他")]
        Other,
    }

    /// <summary>
    /// 检验扩展表类型
    /// </summary>
    public enum InspectionType
    {
        [Description("送检检验")]
        SendTest = 1,
        [Description("人工检验")]
        ManualCollection,
    }

    public enum FileTraceType
    {
        [Description("进料检验")]
        InComingMaterial = 1,
        [Description("送检检验")]
        SendTest,
    }

    public enum StandardType
    {
        [Description("人工检验")]
        ManualCollection = 1,
        [Description("送检检验")]
        SendTest,
    }

    public enum ValueCategory
    {
        [Description("单值")]
        Single = 1,
        [Description("最大值最小值")]
        Maxmin,
    }

    public enum SpcColorType
    {
        [Description("正常")]
        Normal = 1,
        [Description("异常")]
        Abnormal = 2,
        [Description("未检测")]
        NotDetect = 3
    }

    public enum PythonReturnEnum
    {
        Success = 1,

        [Description("无数据")]
        NoData = 500,

        [Description("变量太少")]
        TooFewVariables = 501,

        [Description("子组数量超过数据量")]
        TooManySubgroups = 502,

        [Description("子组数量必须大于2,小于等于9")]
        SubGroupSizeLimit = 503,

        [Description("至少需要25个数据")]
        TooFewRecords = 512,

        [Description("检验数据中没有这个检验项目")]
        ItemNotInCheckData = 513,

        [Description("检验项目未找到")]
        ItemNotFound = 10000,
    }
}
