﻿

namespace Siger.WeComApi.Common.ExcelImport
{
    public class EquipmentTemplate : ImportBase
    {
        [ExcelColumn("设备名称")]
        public string eqname { get; set; }

        [ExcelColumn("设备编号")]
        public string eqid { get; set; }

        [ExcelColumn("设备类型")]
        public string eqtype { get; set; }

        [ExcelColumn("设备驱动")]
        public string eqdriver { get; set; }

        [ExcelColumn("参数")]
        public string para { get; set; }

        [ExcelColumn("维护人")]
        [DonnetCreate]
        [DonnetValidate]
        public string uid { get; set; }

        [ExcelColumn("维护时间")]
        [DonnetCreate]
        [DonnetValidate]
        public string TransDateTime { get; set; }
    }

    public class EquipmentList : EquipmentTemplate
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        public int No { get; set; }
    }

    public class EquipmentPositionTemplate : ImportBase
    {
        [ExcelColumn("生产线")]
        public string line { get; set; }

        [ExcelColumn("工站")]
        public string station { get; set; }

        [ExcelColumn("工位")]
        public string position { get; set; }

        [ExcelColumn("设备编号")]
        public string eqid { get; set; }

        [ExcelColumn("工位脚本")]
        public string scriptname { get; set; }

        [ExcelColumn("维护人")]
        [DonnetValidate]
        [DonnetCreate]
        public string uid { get; set; }

        [ExcelColumn("维护时间")]
        [DonnetCreate]
        [DonnetValidate]
        public string TransDateTime { get; set; }
    }

    public class EquipmentPositionList : EquipmentPositionTemplate
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        public int No { get; set; }
    }
}
