﻿

namespace Siger.WeComApi.Common.ExcelImport
{
    public class MachineList : ImportBase
    {
        [ExcelColumn("ID")]
        [EmptyValidate("IdIsEmpty")]
        public string ID { get; set; }

        [ExcelColumn("设备分类(一级)")]
        [EmptyValidate("MachineParentTypeIsEmpty")]
        public string ParentType { get; set; }

        [ExcelColumn("设备分类(二级)")]
        [EmptyValidate("MachineChildTypeIsEmpty")]
        public string ChildType { get; set; }

        [ExcelColumn("设备名称")]
        [EmptyValidate("MachineNameIsEmpty")]
        public string Name { get; set; }

        [ExcelColumn("固定资产编号")]
        [EmptyValidate("AssetsNoIsEmpty")]
        public string Code { get; set; }

        [ExcelColumn("设备属性(1:设备2:部件3:子系统)")]
        [EmptyValidate("AttributeIsEmpty")]
        public string MachineAttribute { get; set; }

        [ExcelColumn("设备等级(1:普通设备2:重点设备3:瓶颈设备4:非生产设备)")]
        [EmptyValidate("MachineLevelIsEmpty")]
        public string MachineLevel { get; set; }

        [ExcelColumn("生产厂商/品牌")]
        public string Factory { get; set; }

        [ExcelColumn("设备型号")]
        public string Model { get; set; }

        [ExcelColumn("入固日期")]
        public string MadeDate { get; set; }

        [ExcelColumn("出厂编号")]
        public string FactoryCode { get; set; }

        [ExcelColumn("设备类型(1:NC设备2:非NC设备)")]
        [EmptyValidate("MachineNCIsEmpty")]
        public string Category { get; set; }
    }

    public class MachineSkfList : ImportBase
    {
        [ExcelColumn("ID")]
        [EmptyValidate("IDIsEmpty")]
        public string ID { get; set; }

        [ExcelColumn("设备分类(一级)")]
        [EmptyValidate("MachineParentTypeIsEmpty")]
        public string ParentType { get; set; }

        [ExcelColumn("设备分类(二级)")]
        public string ChildType { get; set; }

        [ExcelColumn("设备名称")]
        [EmptyValidate("MachineNameIsEmpty")]
        public string Name { get; set; }

        [ExcelColumn("固定资产编号")]
        [EmptyValidate("CodeIsEmpty")]
        public string Code { get; set; }

        [ExcelColumn("生产厂商/品牌")]
        public string Factory { get; set; }

        [ExcelColumn("设备型号")]
        public string Model { get; set; }

        [ExcelColumn("入固日期")]
        public string MadeDate { get; set; }

        [ExcelColumn("出厂编号")]
        public string FactoryCode { get; set; }


        [ExcelColumn("MachineName")]
        public string machine_name { get; set; }

        [ExcelColumn("设备简称")]
        public string machine_shortname { get; set; }

        [ExcelColumn("负责人")]
        public string responsor { get; set; }

        [ExcelColumn("测试应用产品")]
        public string typical_application { get; set; }

        [ExcelColumn("尺寸-内径")]
        public string inside_diameter { get; set; }

        [ExcelColumn("尺寸-外径")]
        public string outside_diameter { get; set; }

        [ExcelColumn("径向载荷")]
        public string radial_load { get; set; }

        [ExcelColumn("轴向载荷")]
        public string axial_load { get; set; }

        [ExcelColumn("压力")]
        public string pressure { get; set; }

        [ExcelColumn("转速-数字")]
        public string speed { get; set; }

        [ExcelColumn("温度")]
        public string temperature { get; set; }

        [ExcelColumn("转速-文本")]
        public string rotation { get; set; }

        [ExcelColumn("样本润滑")]
        public string sample_lubrication { get; set; }

        [ExcelColumn("设备用油-润滑")]
        public string oil_lubrication { get; set; }

        [ExcelColumn("设备用油-液压")]
        public string oil_hydraulic { get; set; }

        [ExcelColumn("信号采集")]
        public string signal_monitor { get; set; }

        [ExcelColumn("测试工位")]
        public string position { get; set; }

        [ExcelColumn("设备尺寸")]
        public string machine_size { get; set; }
    }

    public class MachineLists : ImportBase
    {

        [ExcelColumn("*父级设备类型")]
        [EmptyValidate("MachineParentTypeIsEmpty")]
        public string ParentType { get; set; }

        [ExcelColumn("*子级设备类型")]
        [EmptyValidate("MachineChildTypeIsEmpty")]
        public string ChildType { get; set; }

        [ExcelColumn("*设备名称")]
        [EmptyValidate("MachineNameIsEmpty")]
        public string Name { get; set; }

        [ExcelColumn("*设备属性(1:设备2:子系统3:部件)")]
        [EmptyValidate("AttributeIsEmpty")]
        public string MachineAttribute { get; set; }

        [ExcelColumn("*设备等级(1:普通设备2:重点设备3:瓶颈设备4:非生产设备)")]
        [EmptyValidate("MachineLevelIsEmpty")]
        public string MachineLevel { get; set; }

        [ExcelColumn("*数采设备(1:NC 2:非NC)")]
        [EmptyValidate("MachineNCIsEmpty")]
        public string Category { get; set; }

        [ExcelColumn("*设备编号")]
        [EmptyValidate("AssetsNoIsEmpty")]
        public string Code { get; set; }

        [ExcelColumn("*接口类型(1:正常设备2:串口设备3:ftp设备4:无系统设备)")]
        [EmptyValidate("AttributeIsEmpty")]
        public string Attribute { get; set; }

        [ExcelColumn("生产商")]
        public string Factory { get; set; }

        [ExcelColumn("设备型号")]
        public string Model { get; set; }

        [ExcelColumn("出厂编号")]
        public string FactoryCode { get; set; }

        [ExcelColumn("入固日期")]
        public string MadeDate { get; set; }

    }

    public class MachineNodeList : ImportBase
    {
        [ExcelColumn("序号")]
        public int No { get; set; }

        [ExcelColumn("节点名称")]
        public string Name { get; set; }

        [ExcelColumn("节点信息")]
        public string Information { get; set; }

        [ExcelColumn("节点日期")]
        public string Date { get; set; }

        [ExcelColumn("节点成本")]
        public string Cost { get; set; }

        [ExcelColumn("操作人")]
        public string User { get; set; }
    }
}
