﻿

namespace Siger.WeComApi.Common.ExcelImport
{
    public class MaterialTemplate : ImportBase
    {
        [ExcelColumn("品名*")]
        public string name { get; set; }

        /// <summary>
        /// 用类别名称
        /// </summary>
        [ExcelColumn("类别*")]
        public string typename { get; set; }

        [ExcelColumn("规格*")]
        [EmptyValidate("SpecIsEmpty")]
        public string spec { get; set; }

        [ExcelColumn("料号*")]
        [EmptyValidate("SNIsEmpty")]
        public string pn { get; set; }

        [ExcelColumn("默认供应商")]
        [EmptyValidate("SupplierIsEmpty")]
        public string supplier { get; set; }

        [ExcelColumn("管理模式*")]
        public string manage_mode { get; set; }

        [ExcelColumn("计量单位*")]
        public string unit { get; set; }

        [ExcelColumn("换算单位")]
        public string conv_unit { get; set; }

        [ExcelColumn("换算比例")]
        public string conv_proportion { get; set; }

        [ExcelColumn("参考价格")]
        public string price { get; set; }

        [ExcelColumn("最低库存数量")]
        public string min_stock { get; set; }

        [ExcelColumn("最高库存数量")]
        public string max_stock { get; set; }

        [ExcelColumn("是否停用")]
        public string is_disable { get; set; }

        [ExcelColumn("是否先进先出")]
        public string is_first { get; set; }

        [ExcelColumn("先进先出级别")]
        public string priority { get; set; }

        [ExcelColumn("保质期")]
        public string exp { get; set; }

        [ExcelColumn("备注")]
        public string desc { get; set; }

        [ExcelColumn("图片")]
        [DonnetValidate]
        [DonnetCreate]
        public string image { get; set; }
    }

    public class MaterialList : MaterialTemplate
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        [DonnetCreate]
        public int No { get; set; }
    }
}
