﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Common.ExcelImport
{
    /// <summary>
    /// 生产计划管理下载模板
    /// </summary>
    public class ProductionPlanList : ImportBase
    {
        [ExcelColumn("产品名称")]
        [EmptyValidate("ProductNameIsEmpty")]
        public string ProductName { get; set; }

        [ExcelColumn("产品图号")]
        [EmptyValidate("ProductDrawCodeIsEmpty")]
        public string ProductDrawingCode { get; set; }

        [ExcelColumn("产品编号")]
        [EmptyValidate("ProductCodeIsEmpty")]
        public string ProductCode { get; set; }

        [ExcelColumn("订单号")]
        //[EmptyValidate("OrderNumberIsEmpty")]
        public string OrderNumber { get; set; }

        [ExcelColumn("工单号")]
        //[EmptyValidate("WorkOrderIsEmpty")]
        public string Code { get; set; }

        [ExcelColumn("工单类型")]
        [EmptyValidate("WorkOrderTypeIsEmpty")]
        public string WorkOrderType { get; set; }

        [ExcelColumn("工单数量")]
        public string InstallCount { get; set; }

        [ExcelColumn("订单数量")]
        //[RegularExpressionValidate("/[1-9]*[1-9][0-9]*$/", "QuantityIsInt")]
        public string Quantity { get; set; }

        [ExcelColumn("交货期")]
        [EmptyValidate("DeliveryTimeIsEmpty")]
        public string DeliveryTime { get; set; }
    }

    /// <summary>
    /// 生产计划管理下载模板
    /// </summary>
    public class ProductionPlanListSaas : ImportBase
    {
        [ExcelColumn("产品名称")]
        [EmptyValidate("ProductNameIsEmpty")]
        public string ProductName { get; set; }

        [ExcelColumn("产品图号")]
        [EmptyValidate("ProductDrawCodeIsEmpty")]
        public string ProductDrawingCode { get; set; }

        [ExcelColumn("产品编号")]
        [EmptyValidate("ProductCodeIsEmpty")]
        public string ProductCode { get; set; }

        [ExcelColumn("订单号")]
        //[EmptyValidate("OrderNumberIsEmpty")]
        public string OrderNumber { get; set; }

        [ExcelColumn("工单号")]
        //[EmptyValidate("WorkOrderIsEmpty")]
        public string Code { get; set; }

        [ExcelColumn("工单类型")]
        [EmptyValidate("WorkOrderTypeIsEmpty")]
        public string WorkOrderType { get; set; }

        [ExcelColumn("工单数量")]
        public string InstallCount { get; set; }

        [ExcelColumn("订单数量")]
        //[RegularExpressionValidate("/[1-9]*[1-9][0-9]*$/", "QuantityIsInt")]
        public string Quantity { get; set; }

        [ExcelColumn("客户名称")]
        public string customername { get; set; }

        [ExcelColumn("订单备注")]
        public string orderremark { get; set; }

        [ExcelColumn("交货期")]
        [EmptyValidate("DeliveryTimeIsEmpty")]
        public string DeliveryTime { get; set; }

        [ExcelColumn("工艺版本(例如1,2,3...)")]
        public string Version { get; set; }
    }
}
