﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Core.Domain.Data
{
    public class LevelSectionTree
    {
        public LevelSectionTree()
        {
            if (children == null)
            {
                children = new List<LevelSectionTree>();
            }
        }
        public int id { get; set; }

        public string name { get; set; }

        public string title { get; set; }

        public int pid { get; set; }

        public bool open { get; set; }

        public bool spread { get; set; } = true;

        public bool @checked { get; set; }

        public int levelId { get; set; }

        public bool disabled { get; set; } = true;

        public int machineid { get; set; }
        /// <summary>
        /// vue专用字段（展开树）
        /// </summary>
        public bool expand { get; set; } = true;

        public List<LevelSectionTree> children { get; set; }

        public void AddChilrden(LevelSectionTree node)
        {
            children.Add(node);
        }

        public int level { get; set; }
    }

    public class ResponseLevelSectionChildren
    {
        public IEnumerable<LevelSectionTree> children { get; set; }

        public ResponseLevelSectionChildren(IEnumerable<LevelSectionTree> tree)
        {
            children = tree;
        }
    }

    public class ResponseLevelSectionList
    {
        public List<ResponseLevelSectionTreeList> sectionTree { get; set; }

        public ResponseLevelSectionList()
        {
            sectionTree = new List<ResponseLevelSectionTreeList>();
        }
    }
    public class ResponseLevelSectionTreeList
    {
        public int id { get; set; }

        public string name { get; set; }

        public int pid { get; set; }

        public bool open { get; set; }

        public bool isleaf { get; set; }

        public int machineid { get; set; }
    }
}
