﻿using System.Collections.Generic;

namespace Siger.WeComApi.Core.Dto.Response
{
    public class ResponseGetSparepart
    {
        public int sort
        {
            get
            {
                //return !System.Text.RegularExpressions.Regex.IsMatch(warehouse, @"^[a-zA-Z]") ? 1 : 0;
                return warehouse.Contains("老") ? 1 : 0;
            }
        }
        public int id { get; set; }

        public string code { get; set; }

        public string title { get; set; }

        public string description { get; set; }

        public string image { get; set; }

        public string param { get; set; }

        public string brand { get; set; }

        public int is_substitute { get; set; }

        public double sku { get; set; }

        public string warehouse { get; set; }

        /// <summary>
        /// 库存状态
        /// </summary>
        public int stock_status { get; set; }

        /// <summary>
        /// 领用异常报警
        /// </summary>
        public int out_status { get; set; } = 0;

        public double thisMonth_in { get; set; } = 0;

        public double thisMonth_out { get; set; } = 0;

        /// <summary>
        /// 计量单位
        /// </summary>
        public string unit { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public double price { get; set; }

        /// <summary>
        /// 材质
        /// </summary>
        public string material { get; set; }

        /// <summary>
        /// 是否为标准件 1->是 0->否
        /// </summary>
        public int is_standard { get; set; }

        /// <summary>
        /// 是否通用配件 1->是 0->否
        /// </summary>
        public int is_common { get; set; }

        /// <summary>
        /// 最高库存
        /// </summary>
        public double max_sku { get; set; }

        /// <summary>
        /// 最低库存
        /// </summary>
        public double mini_sku { get; set; }

        /// <summary>
        /// 库存报警提示人的mid
        /// </summary>
        public string sku_report_mid { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }

        /// <summary>
        /// 供应商
        /// </summary>
        public string supplier { get; set; }

        /// <summary>
        /// 0=>无状态 1=>采购中
        /// </summary>
        public int purchase_status { get; set; }

        /// <summary>
        /// 货期
        /// </summary>
        public float delivery_time { get; set; }

        public int typeid { get; set; }

        public double lastMonth_out { get; set; } = 0;

        public string typeTitle { get; set; }

        public string machinetitle { get; set; }

        public List<double> nums { get; set; }

        public List<string> times { get; set; }

        public double? repair_upperlimit { get; set; }

        public int approvaluser_mid { get; set; }
        /// <summary>
        /// 采购周期
        /// </summary>
        public int? procurement_cycle { get; set; }
        /// <summary>
        /// 是否在备库清单
        /// </summary>
        public int is_sparePartsList { get; set; } = 0;
        /// <summary>
        /// 成本中心
        /// </summary>
        public string cost_center { get; set; }
        /// <summary>
        /// 最小起订量
        /// </summary>
        public double sku_limit { get; set; }

        public IList<SparepartInstockInfo> spareparts { get; set; } = new List<SparepartInstockInfo>();

        /// <summary>
        /// 设备id
        /// </summary>
        public int machineid { get; set; } = 0;
        /// <summary>
        /// 重要等级
        /// </summary>
        public string importlevel { get; set; } = "";
        /// <summary>
        /// 产线层级
        /// </summary>
        public string leveldata { get; set; } = "";

        /// <summary>
        /// 工位id
        /// </summary>
        public int sectionid { get; set; } = 0;
        /// <summary>
        /// 工位名称
        /// </summary>
        public string sectionName { get; set; } = "";
        /// <summary>
        /// 设备名称
        /// </summary>
        public string machineName { get; set; } = "";
    }

    public class ResponseGetSparepartInfo
    {
        public int sort
        {
            get
            {
                //return !System.Text.RegularExpressions.Regex.IsMatch(warehouse, @"^[a-zA-Z]") ? 1 : 0;
                return warehouse.Contains("老") ? 1 : 0;
            }
        }
        public int id { get; set; }

        public string code { get; set; }

        public string title { get; set; }

        public string description { get; set; }

        public string image { get; set; }

        public string param { get; set; }

        public string brand { get; set; }

        public int is_substitute { get; set; }

        public double sku { get; set; }

        public string warehouse { get; set; }

        /// <summary>
        /// 库存状态
        /// </summary>
        public int stock_status { get; set; }

        /// <summary>
        /// 领用异常报警
        /// </summary>
        public int out_status { get; set; } = 0;

        public double thisMonth_in { get; set; } = 0;

        public double thisMonth_out { get; set; } = 0;

        /// <summary>
        /// 计量单位
        /// </summary>
        public string unit { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public double price { get; set; }

        /// <summary>
        /// 材质
        /// </summary>
        public string material { get; set; }

        /// <summary>
        /// 是否为标准件 1->是 0->否
        /// </summary>
        public int is_standard { get; set; }

        /// <summary>
        /// 是否通用配件 1->是 0->否
        /// </summary>
        public int is_common { get; set; }

        /// <summary>
        /// 最高库存
        /// </summary>
        public double max_sku { get; set; }

        /// <summary>
        /// 最低库存
        /// </summary>
        public double mini_sku { get; set; }

        /// <summary>
        /// 库存报警提示人的mid
        /// </summary>
        public string sku_report_mid { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }

        /// <summary>
        /// 供应商
        /// </summary>
        public string supplier { get; set; }

        /// <summary>
        /// 0=>无状态 1=>采购中
        /// </summary>
        public int purchase_status { get; set; }

        /// <summary>
        /// 货期
        /// </summary>
        public float delivery_time { get; set; }

        public int typeid { get; set; }

        public double lastMonth_out { get; set; } = 0;

        public string typeTitle { get; set; }

        public string machinetitle { get; set; }

        public List<double> nums { get; set; }

        public List<string> times { get; set; }

        public double? repair_upperlimit { get; set; }

        public int approvaluser_mid { get; set; }
        /// <summary>
        /// 采购周期
        /// </summary>
        public int? procurement_cycle { get; set; }
        /// <summary>
        /// 是否在备库清单
        /// </summary>
        public int is_sparePartsList { get; set; } = 0;
        /// <summary>
        /// 成本中心
        /// </summary>
        public string cost_center { get; set; }
        /// <summary>
        /// 最小起订量
        /// </summary>
        public double sku_limit { get; set; }

        public IList<SparepartInstockInfo> spareparts { get; set; } = new List<SparepartInstockInfo>();

        /// <summary>
        /// 设备id
        /// </summary>
        public int machineid { get; set; } = 0;
        /// <summary>
        /// 重要等级
        /// </summary>
        public string importlevel { get; set; } = "";

        /// <summary>
        /// 工位id
        /// </summary>
        public int sectionid { get; set; } = 0;
        /// <summary>
        /// 工位名称
        /// </summary>
        public string sectionName { set; get; } = "";
        /// <summary>
        /// 设备名称
        /// </summary>
        public string machineName { set; get; } = "";
    }

    public class ResponseGetSparepartResult : ResponseGetSparepartInfo
    { 
        public int[] leveldata { get; set; }
    }

    public class SparepartInstockInfo
    {
        public string code { get; set; }

        public int repair_count { get; set; } = 0;
    }
}
