﻿using Siger.WeComApi.Common.Helpers;
using Siger.WeComApi.Core.Enum;

namespace Siger.WeComApi.Core.Dto
{
    public class SigerUserDto
    {
        /// <summary>
        /// 
        ///</summary>
        public int Id { get; set; }

        /// <summary>
        /// 废弃
        ///</summary>
        public string Userid { get; set; } = string.Empty;

        /// <summary>
        /// 
        ///</summary>
        public string Password { get; set; } = string.Empty;

        /// <summary>
        /// 
        ///</summary>
        public string Nickname { get; set; } = string.Empty;

        /// <summary>
        /// 
        ///</summary>
        public string Face { get; set; } = string.Empty;

        /// <summary>
        /// 0->男;1->女;2->男变女;3->女变男
        ///</summary>
        public int Sex { get; set; }

        /// <summary>
        /// 
        ///</summary>
        public string Email { get; set; } = string.Empty;

        /// <summary>
        /// 0->;未验证 1->;已验证
        ///</summary>
        public int EmailStatus { get; set; }

        /// <summary>
        /// 
        ///</summary>
        public string Mobile { get; set; } = string.Empty;

        /// <summary>
        /// 0->未验证 1->已验证
        ///</summary>
        public int MobileStatus { get; set; }

        /// <summary>
        /// -1->;账号无效 0->待审核; 1 ->正常使用
        ///</summary>
        public int Status { get; set; }

        /// <summary>
        /// 
        ///</summary>
        public int Jointime { get; set; }

        /// <summary>
        /// 
        ///</summary>
        public string Joinip { get; set; } = string.Empty;

        /// <summary>
        /// 
        ///</summary>
        public int Lastlogintime { get; set; }

        /// <summary>
        /// 0->普通会员 1->开店会员 2->管理员
        ///</summary>
        public int Type { get; set; }

        /// <summary>
        /// 被赞数量
        ///</summary>
        public int Zan { get; set; }

        /// <summary>
        /// 粉丝数量
        ///</summary>
        public int Fans { get; set; }

        /// <summary>
        /// 关注数量
        ///</summary>
        public int Follow { get; set; }

        /// <summary>
        /// 滴辣不沾,微辣,中辣,巨辣,变态辣,重口味
        ///</summary>
        public string Taste { get; set; } = string.Empty;

        /// <summary>
        /// 最多256个汉字，用英文下逗号隔开
        ///</summary>
        public string AvoidCertainFood { get; set; } = string.Empty;

        /// <summary>
        /// 个人简介，理论上最多500个字
        ///</summary>
        public string Message { get; set; } = string.Empty;

        /// <summary>
        /// 用户获得积分
        ///</summary>
        public int Score { get; set; }

        /// <summary>
        /// 账户余额（充值用）
        ///</summary>
        public decimal Balance { get; set; }

        /// <summary>
        /// 生日
        ///</summary>
        public int Birthday { get; set; }

        /// <summary>
        /// 真实姓名
        ///</summary>
        public string Realname { get; set; } = string.Empty;

        /// <summary>
        /// 用户权限JSON字符串 如：{&quot;version&quot;:&quot;2016-07-21 23:29:58&quot;,&quot;list&quot;:[{&quot;section&quot;:&quot;OA系统&quot;,&quot;selected&quot;:&quot;1&quot;,&quot;lists&quot;:[{&quot;name&quot;:&quot;签到系统&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;sign&quot;,&quot;selected&quot;:&quot;0&quot;},{&quot;name&quot;:&quot;工作计划&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;task&quot;,&quot;selected&quot;:&quot;0&quot;},{&quot;name&quot;:&quot;工作墙&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;jobwall&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;工作日志&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;performance&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;财务记录&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;charge&quot;,&quot;selected&quot;:&quot;1&quot;}]},{&quot;section&quot;:&quot;互动管理&quot;,&quot;selected&quot;:&quot;1&quot;,&quot;lists&quot;:[{&quot;name&quot;:&quot;会员列表&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;userlist&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;评论列表&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;commentlist&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;友链管理&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;friendlinklist&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;消息列表&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;messagelist&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;用户反馈&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;feedback&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;设备列表&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;devicelist&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;错误报告&quot;,&quot;type&quot;:&quot;link&quot;
        ///</summary>
        public string Power { get; set; } = string.Empty;

        /// <summary>
        /// 0->;非demo账号 1->;demo 账号 注意：demo账号的意思是，很多敏感权限将进行关闭，比如财务，项目，删除等操作。
        ///</summary>
        public int Demo { get; set; }

        /// <summary>
        /// 毕业院校
        ///</summary>
        public string Graduate { get; set; } = string.Empty;

        /// <summary>
        /// _user_roles id 对应
        ///</summary>
        public int Roleid { get; set; }

        /// <summary>
        /// 
        ///</summary>
        public int? RefreshTime { get; set; }

        public string SexDes
        {
            get
            {
                return EnumHelper.GetDescription(typeof(UserSexEnum), Sex, "未知");
            }
        }
    }
}
