﻿using Siger.WeComApi.Core.Domain;
using Siger.WeComApi.Core.Domain.Entity;
using System.Collections.Generic;

namespace Siger.WeComApi.Core.Repository
{
    public interface IApiConfigRepositoryBase<TEntity> : IRepositoryBase<TEntity> where TEntity : ConfigEntityBase
    {
        int GetProjectLanguage(int projectId);
        string GetLineLevelTitlebByMachine(int machine, int projectId);

        string GetMachineLocationBySectionId(int sectionId, int projectId);
        string GetMachineLocationByMachineId(int machineId, int projectId);
        IEnumerable<siger_project_machine_attribution> GetSonLevelMachineAttribution(int parentId, int projectid);

        string GetUserNamesByMids(string mids, int projectId);

        bool GetMachineStateByMid(int mid, int projectId);
    }
}