﻿using Microsoft.AspNetCore.Mvc;
using Senparc.Weixin.Work.Tencent;
using Microsoft.AspNetCore.Http;
using Siger.CommonUtil.Logging;
using System;
using System.IO;
using System.Xml.Linq;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Siger.ApiTPM.Utilities;
using Siger.WeComApi.WebApi.Controllers;
using Siger.WeComApi.Core.Biz;
using Siger.WeComApi.Common.Filter;

namespace Siger.ApiTPM.Controllers
{
    public class CallbackController : BaseController
    {
        private readonly ISigerLogger<CallbackController> _logger;
        private readonly ISigerWeComThirdService _sigerWeComThirdService;

        public CallbackController(ISigerLogger<CallbackController> logger, ISigerWeComThirdService sigerWeComThirdService)
        {
            this._logger = logger;
            this._sigerWeComThirdService = sigerWeComThirdService;
        }

        /// <summary>
        /// 数据响应回调
        /// </summary>
        /// <returns></returns>
        [NoTokenValidateFilter]
        public ActionResult Instruct()
        {
            string result = "success";
            try
            {
                string httpMethod = Request.Method.ToUpper();
                if (httpMethod == "GET")
                {
                    //数据响应回调 验证回调URL(注意：企业回调的url-该url不做任何的业务逻辑，仅仅微信查看是否可以调通)
                    result = _sigerWeComThirdService.GetVerify(Request);
                }
                else
                {
                    //指令响应回调 在发生授权、通讯录变更、ticket变化等事件时，企业微信服务器会向应用的“指令回调URL”推送相应的事件消息。
                    result = _sigerWeComThirdService.InstructCallback(Request);
                }
            }
            catch (Exception ex)
            {
                result = "企微回调异常：" + ex.Message;
            }
            return Content(result);
        }

        /// <summary>
        /// 指令响应回调
        /// </summary>
        /// <returns></returns>
        [NoTokenValidateFilter]
        public ActionResult InstructPost()
        {
            try
            {

            }
            catch (Exception ex)
            {
                _logger.Info("企微指令回调异常：" + ex.Message);
            }
            return Content("fail");
        }
    }
}
