﻿using Microsoft.AspNetCore.Mvc.Filters;
using Siger.WeComApi.Common.Constants;
using Siger.WeComApi.Common.Enums;
using Siger.WeComApi.Common.Exceptions;
using Siger.WeComApi.Common.Helpers;
using System.Linq;

namespace Siger.WeComApi.Common.Filter
{
    public class TokenValidateFilter : ActionFilterAttribute
    {
        public override void OnActionExecuting(ActionExecutingContext context)
        {
            if (context.Filters.Any(q => q.GetType() == typeof(NoTokenValidateFilter)))
            {
                return;
            }
            var referer = HeadHelper.GetHead(context.HttpContext.Request, ParameterConstant.Referer);
            if (referer != null && referer.Contains("swagger/ui") && referer.Contains("projectid="))
            {
                return;
            }
            var token = HeadHelper.GetHead(context.HttpContext.Request, ParameterConstant.Token);
            if (token == null)
            {
                throw new BadRequestException(CommonEnum.TokenIsEmpty);
            }
            var isvalid = TokenHelper.Instance.IsValidToken(token);
            if (!isvalid)
            {
                throw new BadRequestException(CommonEnum.TokenIsInvalid);
            }
            var timestamp = HeadHelper.GetHead(context.HttpContext.Request, ParameterConstant.TimeStamp);
            if (timestamp == null)
            {
                throw new BadRequestException(CommonEnum.TimeStampIsEmpty);
            }
            var random = HeadHelper.GetHead(context.HttpContext.Request, ParameterConstant.Nonce);
            if (random == null)
            {
                throw new BadRequestException(CommonEnum.NonceIsEmpty);
            }
            var signValue = HeadHelper.GetHead(context.HttpContext.Request, ParameterConstant.Sign);
            if (signValue == null)
            {
                throw new BadRequestException(CommonEnum.SignIsEmpty);
            }

            var unSignedParameter = $"timestamp={timestamp}&nonce={random}";
            var signed = MD5Helper.GetHashString(unSignedParameter);
            if (!signed.Equals(signValue, System.StringComparison.CurrentCultureIgnoreCase))
            {
                throw new BadRequestException(CommonEnum.SignIsInvalid);
            }
        }


    }
}
