﻿using Siger.WeComApi.Core.Domain;
using Siger.WeComApi.Core.Domain.Paged;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Threading.Tasks;

namespace Siger.WeComApi.Core.Repository
{
    /// <summary>
    /// 仓库基础类
    /// </summary>
    /// <typeparam name="TEntity"></typeparam>
    public interface IRepositoryBase<TEntity> where TEntity : EntityBase
    {
        /// <summary>
        /// insert
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        void Insert(TEntity entity);

        /// <summary>
        /// insert
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        Task InsertAsync(TEntity entity);

        /// <summary>
        /// 批量 insert
        /// </summary>
        /// <param name="entities"></param>
        /// <returns></returns>
        Task InsertAsync(IEnumerable<TEntity> entities);

        /// <summary>
        /// Update
        /// </summary>
        /// <param name="entity"></param>
        void Update(TEntity entity);

        /// <summary>
        /// UpdateRange
        /// </summary>
        /// <param name="entities"></param>
        void UpdateRange(params TEntity[] entities);

        /// <summary>
        /// Delete
        /// </summary>
        /// <param name="id"></param>
        void Delete(object id);

        /// <summary>
        /// DeleteAsync
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        Task DeleteAsync(object id);

        /// <summary>
        /// Delete
        /// </summary>
        /// <param name="entity"></param>
        void Delete(TEntity entity);

        /// <summary>
        /// DeleteAsync
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        Task DeleteAsync(TEntity entity);

        /// <summary>
        /// 根据主键获取对象
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        TEntity Get(object key);

        /// <summary>
        /// 根据主键获取对象
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        TEntity Get(Expression<Func<TEntity, bool>> predicate);

        /// <summary>
        /// 根据主键获取对象
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        Task<TEntity> GetAsync(object key);

        /// <summary>
        /// 根据条件获取单个对象
        /// </summary>
        /// <param name="predicate"></param>
        /// <returns></returns>
        Task<TEntity> GetAsync(Expression<Func<TEntity, bool>> predicate);

        /// <summary>
        /// 根据条件获取单个对象
        /// </summary>
        /// <param name="predicate"></param>
        /// <param name="orderByPropertyName"></param>
        /// <param name="desc"></param>
        /// <returns></returns>
        Task<TEntity> GetAsync(Expression<Func<TEntity, bool>> predicate, string orderByPropertyName = null, bool desc = true);

        /// <summary>
        /// 是否存在满足条件的数据
        /// </summary>
        /// <param name="predicate"></param>
        /// <returns></returns>
        Task<bool> IsExistAsync(Expression<Func<TEntity, bool>> predicate);

        /// <summary>
        /// 集合查询
        /// </summary>
        /// <param name="predicate"></param>
        /// <param name="orderByPropertyName"></param>
        /// <param name="desc"></param>
        /// <returns></returns>
        List<TEntity> GetList(Expression<Func<TEntity, bool>> predicate = null, string orderByPropertyName = null, bool desc = true);

        /// <summary>
        /// 集合查询
        /// </summary>
        /// <param name="predicate"></param>
        /// <param name="orderByPropertyName"></param>
        /// <param name="desc"></param>
        /// <returns></returns>
        Task<List<TEntity>> GetListAsync(Expression<Func<TEntity, bool>> predicate = null, string orderByPropertyName = null, bool desc = true);


        /// <summary>
        /// 分页查询
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="predicate"></param>
        /// <param name="orderByPropertyName"></param>
        /// <param name="desc"></param>
        /// <returns></returns>
        Task<PagedCollectionResult<TEntity>> GetPagedListAsync(int pageIndex, int pageSize, Expression<Func<TEntity, bool>> predicate = null, string orderByPropertyName = null, bool desc = true);
        #region 执行Sql方法
        /// <summary>
        /// sql 执行
        /// </summary>
        /// <param name="sql"></param>
        /// <returns></returns>
        Task<int> ExecuteSqlRawAsync(string sql);
        #endregion 
    }
}
