﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Siger.WeComApi.Common.cache;
using Siger.WeComApi.Common.Enums.Extensions;
using Siger.Middlelayer.Redis.RedisEntities;

namespace Siger.Middlelayer.Redis
{
    public partial class RedisCache
    {
        private const string LicenseHash = "Licenses";

        /// <summary>
        /// 判定服务是否正常
        /// </summary>
        /// <returns></returns>
        public async Task CheckRunning()
        {
            try
            {
                var licenses = await CacheUtility.Instance.HGetAllAsync(LicenseHash);
                if (licenses.Any())
                {
                    throw new Exception("monitor: redis service is running.");
                }
            }
            catch(Exception e)
            {
                throw new Exception("monitor: redis service is blocked, error : " + e);
            }
        }

        public async Task<IEnumerable<LicenseEntity>> GetLicenses()
        {
            var licenses = new List<LicenseEntity>();
            var configs = await CacheUtility.Instance.HGetAllAsync(LicenseHash);
            foreach (var config in configs)
            {
                var cidpid = config.Key.Split('_');
                licenses.Add(new LicenseEntity
                {
                    Cid = cidpid[0].ToInt(),
                    Pid = cidpid[1].ToInt(),
                    License = config.Value
                });
            }

            return licenses.OrderBy(q => q.Cid);
        }

        public async Task AddLicenseEntity(LicenseEntity license)
        {
            var key = $"{license.Cid}_{license.Pid}";

            await CacheUtility.Instance.SetHashAsync(LicenseHash, key, license.License);
        }

        public void DeleteLicenseEntity(string key)
        {
            CacheUtility.Instance.DeleteHost(LicenseHash, key);
        }


        public async Task<string> GetLicense(string key)
        {
            return await CacheUtility.Instance.GetHashAsync(LicenseHash, key);
        }

    }
}
