﻿
using Siger.WeComApi.Common.Enums.Extensions;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Text;

namespace Siger.WeComApi.Core.Domain.Entity
{
    public class siger_project_working_relation_machine : ConfigEntityBase
    {
        public int projectid { get; set; }
        /// <summary>
        /// 部门ID
        /// </summary>
        public int section { get; set; }
        /// <summary>
        /// 班组别ID
        /// </summary>
        public int workgroup_id { get; set; }
        /// <summary>
        /// 产线层级
        /// </summary>
        public int station { get; set; }
        /// <summary>
        /// 设备ID
        /// </summary>
        public int machine { get; set; }
        /// <summary>
        /// 设备对多个排班人员 以逗号分隔
        /// </summary>
        public string employs { get; set; }
        /// <summary>
        /// 设备对多个排班人员集合
        /// </summary>
        [NotMapped]
        public List<int> employsSplit { get { return employs.TrimEnd(',').Split(',').Select(x => x.ToInt()).ToList(); } }
    }
}
