﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Core.Dto.Response
{
    public class ResponseMachineMangeList
    {
        /// <summary>
        /// 工位id
        /// </summary>
        public int Station { get; set; }

        /// <summary>
        /// 位置
        /// </summary>
        public string Position { get; set; }

        /// <summary>
        /// 设备名称
        /// </summary>
        public string MachineName { get; set; }

        /// <summary>
        /// 设备id
        /// </summary>
        public int MachineId { get; set; }

        /// <summary>
        /// 设备编号
        /// </summary>
        public string MachineCode { get; set; }

        /// <summary>
        /// 设备属性 1设备2子系统3部件
        /// </summary>
        public int Attribution { get; set; }

        /// <summary>
        /// 接口类型 1正常设备2串口设备3ftp设备4无系统设备
        /// </summary>
        public int InterfaceType { get; set; }

        /// <summary>
        /// 设备类型
        /// </summary>
        public string MachineType { get; set; }

        /// <summary>
        /// 生产商
        /// </summary>
        public string Factory { get; set; }

        /// <summary>
        /// 设备型号
        /// </summary>
        public string MachineModel { get; set; }

        /// <summary>
        /// 出厂编号
        /// </summary>
        public string FactoryCode { get; set; }

        /// <summary>
        /// 入固日期
        /// </summary>
        public string ReceiveTime { get; set; }

        /// <summary>
        /// 入固日期
        /// </summary>
        public DateTime CreateTime { get; set; }


        /// <summary>
        /// 设备类型id
        /// </summary>
        public int MachineTypeId { get; set; }

        /// <summary>
        /// 父级设备类型id
        /// </summary>
        public int ParentMachineType { get; set; }

        /// <summary>
        /// 设备等级
        /// </summary>
        public int MachineLevel { get; set; }

        /// <summary>
        /// 数采设备
        /// </summary>
        public int Category { get; set; }

        /// <summary>
        /// 排序
        /// </summary>
        public int Sort { get; set; }

        /// <summary>
        /// 图片url
        /// </summary>
        public string ImageUrl { get; set; }


        /// <summary>
        /// 是否入固
        /// </summary>
        public int IsReceive { get; set; }
    }
}
