﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.WeComApi.Core.Domain.Entity;
using Siger.WeComApi.Repository;
using Siger.WeComApi.Common.Enums;
using Siger.WeComApi.Core.Domain.Data;
using Siger.WeComApi.Core.Domain.Paged;
using Siger.WeComApi.Repository.Extensions;
using Siger.WeComApi.Core.Dto.Response;
using Siger.WeComApi.Common.Enums.Extensions;
using Siger.WeComApi.Core.Repository;

namespace Siger.Middlelayer.Repository.Repositories
{
    internal class SigerProjectRepository : ApiConfigRepositoryBase<siger_project>, ISigerProjectRepository
    {
        /// <summary>
		/// 主库,写操作
		/// </summary>
		protected new readonly BaseDataDbContext DbMaster;

        /// <summary>
        /// 从库,读操作
        /// </summary>
        protected new readonly BaseDataReadDbContext DbSlave;
        public SigerProjectRepository(BaseDataDbContext dbMaster, BaseDataReadDbContext dbSlave) : base(dbMaster, dbSlave)
        {
            this.DbMaster = dbMaster; this.DbSlave = dbSlave;
        }

        public Project GetProject(int id)
        {
            var query = DbSlave.siger_project.Where(q => q.status == (int)RowState.Valid && q.id == id);
            var queryList = from q in query
                join c in DbSlave.siger_company on q.companyid equals c.id.ToString()
                where c.status == (int)RowState.Valid
                join u1 in DbSlave.siger_user on q.mid equals u1.id into user1
                from u1 in user1.DefaultIfEmpty()
                where u1.status == (int)RowState.Valid
                join u2 in DbSlave.siger_user on q.dutymid equals u2.id into user2
                from u2 in user2.DefaultIfEmpty()
                where u2.status == (int)RowState.Valid
                join u3 in DbSlave.siger_user on q.salesmid equals u3.id into user3
                from u3 in user3.DefaultIfEmpty()
                where u3.status == (int)RowState.Valid
                join type in DbSlave.siger_project_type on q.typeid equals type.id
                select new Project
                {
                    projectid = q.id,
                    title = q.title,
                    companyid = c != null ? c.id : 0,
                    companyname = c != null ? c.chinesename : "",
                    createtime = q.createtime,
                    description = q.description,
                    finaloffer = q.finaloffer == 0 ? "" : q.finaloffer.ToString(),
                    initialquotation = q.initialquotation == 0 ? "" : q.initialquotation.ToString(),
                    mid = u1 != null ? u1.id : 0,
                    creatname = u1 != null ? u1.realname : "",
                    responsibleid = u2 != null ? u2.id : 0,
                    managemobile = u2 != null ? u2.mobile : "",
                    managename = u2 != null ? u2.realname : "",
                    saleid = u3 != null ? u3.id : 0,
                    salename = u3 != null ? u3.nickname : "",
                    typeid = type != null ? type.id : 0,
                    typename = type != null ? type.name : "",
                    dutymid = q.dutymid,
                    modular = q.modular,
                    dashboard_ids = q.dashboard_ids
                };
            return queryList.FirstOrDefault();
        }

        public IPagedCollectionResult<Project> GetPagedCollectionResult(string title, string mid,
            string companyid, string dutymid, string salesmid, string typeid, int page, int pagesize, int companyType, int parentId)
        {
            var query = DbSlave.siger_project.Where(q => q.status == (int) RowState.Valid);
            IQueryable<Project> queryList;

            if (companyType != (int)CustomerType.Channel)
            {
                queryList = from q in query
                            join c in DbSlave.siger_company on q.companyid equals c.id.ToString()
                            where c.status == (int)RowState.Valid
                            join u1 in DbSlave.siger_user on q.mid equals u1.id into user1
                            from u1 in user1.DefaultIfEmpty()
                            where u1.status == (int)RowState.Valid
                            join u2 in DbSlave.siger_user on q.dutymid equals u2.id into user2
                            from u2 in user2.DefaultIfEmpty()
                            where u2.status == (int)RowState.Valid
                            join u3 in DbSlave.siger_user on q.salesmid equals u3.id into user3
                            from u3 in user3.DefaultIfEmpty()
                            where u3.status == (int)RowState.Valid
                            join type in DbSlave.siger_project_type on q.typeid equals type.id
                            select new Project
                            {
                                projectid = q.id,
                                title = q.title,
                                companyid = c != null ? c.id : 0,
                                companyname = c != null ? c.chinesename : "",
                                createtime = q.createtime,
                                description = q.description,
                                finaloffer = q.finaloffer == 0 ? "" : q.finaloffer.ToString(),
                                initialquotation = q.initialquotation == 0 ? "" : q.initialquotation.ToString(),
                                mid = u1 != null ? u1.id : 0,
                                creatname = u1 != null ? u1.realname : "",
                                dutymid = u2 != null ? u2.id : 0,
                                mobile = u2 != null ? u2.mobile : "",
                                responsiblename = u2 != null ? u2.realname : "",
                                saleid = u3 != null ? u3.id : 0,
                                salename = u3 != null ? u3.nickname : "",
                                typeid = type != null ? type.id : 0,
                                typename = type != null ? type.name : "",
                                dashboard_ids = q.dashboard_ids
                            };
            }
            else
            {
                queryList = from q in query
                            join c in DbSlave.siger_company on q.companyid equals c.id.ToString()
                            where c.status == (int)RowState.Valid
                            join u1 in DbSlave.siger_user on q.mid equals u1.id into user1
                            from u1 in user1.DefaultIfEmpty()
                            where u1.status == (int)RowState.Valid
                            join u2 in DbSlave.siger_user on q.dutymid equals u2.id into user2
                            from u2 in user2.DefaultIfEmpty()
                            where u2.status == (int)RowState.Valid
                            join u3 in DbSlave.siger_user on q.salesmid equals u3.id into user3
                            from u3 in user3.DefaultIfEmpty()
                            where u3.status == (int)RowState.Valid
                            join type in DbSlave.siger_project_type on q.typeid equals type.id
                            join t in DbSlave.ProjectChannelTerminalRelationEntity on c.id equals t.Company
                            where t.ParentCompany == parentId
                            select new Project
                            {
                                projectid = q.id,
                                title = q.title,
                                companyid = c != null ? c.id : 0,
                                companyname = c != null ? c.chinesename : "",
                                createtime = q.createtime,
                                description = q.description,
                                finaloffer = q.finaloffer == 0 ? "" : q.finaloffer.ToString(),
                                initialquotation = q.initialquotation == 0 ? "" : q.initialquotation.ToString(),
                                mid = u1 != null ? u1.id : 0,
                                creatname = u1 != null ? u1.realname : "",
                                dutymid = u2 != null ? u2.id : 0,
                                mobile = u2 != null ? u2.mobile : "",
                                responsiblename = u2 != null ? u2.realname : "",
                                saleid = u3 != null ? u3.id : 0,
                                salename = u3 != null ? u3.nickname : "",
                                typeid = type != null ? type.id : 0,
                                typename = type != null ? type.name : "",
                                dashboard_ids = q.dashboard_ids
                            };
            }

            Expression<Func<Project, bool>> titleExpression = q => true;
            if (!string.IsNullOrEmpty(title))
            {
                titleExpression = q => q.title.Contains(title);
            }
            Expression<Func<Project, bool>> midExpression = q => true;
            if (!string.IsNullOrEmpty(mid))
            {
                midExpression = q => q.mid == int.Parse(mid);
            }
            Expression<Func<Project, bool>> companyidExpression = q => true;
            if (!string.IsNullOrEmpty(companyid))
            {
                companyidExpression = q => q.companyid == int.Parse(companyid);
            }
            Expression<Func<Project, bool>> dutymidExpression = q => true;
            if (!string.IsNullOrEmpty(dutymid))
            {
                dutymidExpression = q => q.dutymid == int.Parse(dutymid);
            }
            Expression<Func<Project, bool>> salesmidExpression = q => true;
            if (!string.IsNullOrEmpty(salesmid))
            {
                salesmidExpression = q => q.saleid == int.Parse(salesmid);
            }
            Expression<Func<Project, bool>> typeidExpression = q => true;
            if (!string.IsNullOrEmpty(typeid))
            {
                typeidExpression = q => q.typeid == int.Parse(typeid);
            }

            var predicate = titleExpression.And(midExpression).And(companyidExpression).And(dutymidExpression)
                .And(salesmidExpression)
                .And(typeidExpression);

            var totalCount = queryList.Count(predicate);
            var entities = queryList.Where(predicate).OrderBy(q => q.projectid).Skip((page -1) * pagesize).Take(pagesize).AsNoTracking().ToList();

            return new PagedCollectionResult<Project>(entities, totalCount);
        }

        public IEnumerable<ResponseIdTitle> GetAllDashboards()
        {
            var dashboards = DbSlave.siger_project_dashboard_page.Where(q => q.status == (int)RowState.Valid)
                .Select(m => new ResponseIdTitle
                {
                    id = m.id,
                    title = m.page_title
                });
            return dashboards.ToList();
        }

        /// <summary>
        /// type
        /// </summary>
        /// <param name="customerType"></param>
        /// <param name="parentCompany"></param>
        /// <param name="type">type:0 项目负责人 2：项目销售</param>
        /// <returns></returns>
        public IEnumerable<ResponseGetAdminsForDorpdown>GetProjectUser(int type,int customerType,int parentCompany)
        {
            if (customerType == (int)CustomerType.Channel && type == 0)
            {
                var query = (from p in DbSlave.ProjectChannelTerminalRelationEntity
                            join q in DbSlave.siger_project on p.Company equals q.companyid.ToInt()
                            join u in DbSlave.siger_user on q.dutymid equals u.id
                            where p.Status == (int)RowState.Valid && q.status == (int)RowState.Valid
                            && p.ParentCompany == parentCompany
                            select new ResponseGetAdminsForDorpdown
                            {
                                id = u.id,
                                nickname = u.nickname,
                                realname = u.realname,
                                roleid = u.roleid
                            }).Distinct().AsEnumerable(); ;

                return query;
            }

            if (customerType == (int)CustomerType.Channel && type == 1)
            {
                var query = (from p in DbSlave.ProjectChannelTerminalRelationEntity
                            join q in DbSlave.siger_project on p.Company equals q.companyid.ToInt()
                            join u in DbSlave.siger_user on q.salesmid equals u.id
                            where p.Status == (int)RowState.Valid && q.status == (int)RowState.Valid
                            && p.ParentCompany == parentCompany
                            select new ResponseGetAdminsForDorpdown
                            {
                                id = u.id,
                                nickname = u.nickname,
                                realname = u.realname,
                                roleid = u.roleid
                            }).Distinct().AsEnumerable(); ;

                return query;
            }


            if (type == 0)
            {
                var query = (from p in DbSlave.siger_project
                            join u in DbSlave.siger_user on p.dutymid equals u.id
                            where p.status == (int)RowState.Valid
                            select new ResponseGetAdminsForDorpdown
                            {
                                id = u.id,
                                nickname = u.nickname,
                                realname = u.realname,
                                roleid = u.roleid
                            }).Distinct().AsEnumerable(); ;
                return query;
            }
            var querySale = (from p in DbSlave.siger_project
                        join u in DbSlave.siger_user on p.salesmid equals u.id
                        where p.status == (int)RowState.Valid
                        select new ResponseGetAdminsForDorpdown
                        {
                            id = u.id,
                            nickname = u.nickname,
                            realname = u.realname,
                            roleid = u.roleid
                        }).Distinct().AsEnumerable(); ;
            return querySale;
        }

        public IEnumerable<ResponseProjectInfo> GetProjectByName(string name, int companyId)
        {
            var query = from q in DbSlave.siger_project
                        join p in DbSlave.ProjectChannelTerminalRelationEntity on q.companyid.ToInt() equals p.Company
                        where q.status == (int)RowState.Valid && p.Status == (int)RowState.Valid
                        && p.ParentCompany == companyId
                        select new ResponseProjectInfo
                        {
                            Id = q.id,
                            FactoryName = q.title
                        };
            if (!string.IsNullOrWhiteSpace(name))
            {
                query = query.Where(q => q.FactoryName.Contains(name));
            }

            return query;
        }
    }
}
