﻿using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Primitives;
using Siger.CommonUtil.Extensions;
using Siger.WeComApi.Common.CommonModels;
using Siger.WeComApi.Common.Constants;
using Siger.WeComApi.Common.Helpers;

namespace Siger.WeComApi.WebApi.Controllers
{
    /// <summary>
    /// BaseController
    /// </summary>
    [Route("WeCom/[controller]/[action]")]
    [EnableCors("Cors")]
    public class BaseController : ControllerBase
    {
        /// <summary>
        /// default PageIndex is 10
        /// </summary>
        public const int PageIndex = 1;

        /// <summary>
        /// default pagesize is 10
        /// </summary>
        public const int PageSize = 10;

        /// <summary>
        /// 企业id
        /// </summary>
        public int CompanyId => TokenValue == null ? 0 : TokenValue.CompanyId;
        /// <summary>
        /// 项目id
        /// </summary>
        public int ProjectId => TokenValue == null ? 0 : TokenValue.ProjectId;

        /// <summary>
        /// 用户id
        /// </summary>
        public int UserId => TokenValue == null ? 0 : TokenValue.UserId;

        /// <summary>
        /// 用户权限id
        /// </summary>
        public int RoleId => TokenValue == null ? 0 : TokenValue.RoleId;


        /// <summary>
        /// 用户所属公司的类型(1渠道客户 2终端客户)
        /// </summary>
        public int CompanyType => TokenValue == null ? 0 : TokenValue.CompanyType;
        /// <summary>
        /// token value
        /// </summary>
        public TokenValue TokenValue
        {
            get
            {
                var hasValue = HttpContext.Request.Headers.TryGetValue(ParameterConstant.Token, out StringValues token);
                if (hasValue)
                {
                    return TokenHelper.Instance.GetTokenValue(token);
                }
                var hasParameter = HttpContext.Request.Headers.TryGetValue(ParameterConstant.Referer, out StringValues referer);
                if (hasParameter && referer.ToString().Contains("projectid="))
                {
                    return CreateToken(referer.ToString());
                }
                return null;
            }
        }

        private TokenValue CreateToken(string referer)
        {
            var companyid = TokenHelper.GetQueryString("companyid", referer).ToInt32();
            var projectid = TokenHelper.GetQueryString("projectid", referer).ToInt32();
            var userid = TokenHelper.GetQueryString("userid", referer).ToInt32();
            var companytype = TokenHelper.GetQueryString("companytype", referer).ToInt32();

            return new TokenValue(companyid == 0 ? projectid : companyid, projectid, userid, 0, companytype);
        }

        /// <summary>
        /// 用户ip
        /// </summary>
        public string ServerIpAddress
        {
            get
            {
                try
                {
                    return Request.HttpContext.Connection.LocalIpAddress.MapToIPv4().ToString();
                }
                catch
                {
                    return "127.0.0.1";
                }
            }
        }
    }
}
