﻿using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Siger.CommonUtil.UniformConfigExtend;

namespace Siger.WeComApi.Common.config
{
    /// <summary>
    /// 配置中心
    /// </summary>
    public static class ConfigCenter
    {
        public static IServiceCollection RegisterConfigCenter(this IServiceCollection app, IConfiguration configuration)
        {
            var configState = configuration["IsUseConfigCenter"];
            if (configState == "1")
            {
                var urlPath = configuration["UnifromUrl"];
                int cid = 0, pid = 0;
                var groupIdInfo = configuration["GroupId"];
                if (groupIdInfo != null)
                {
                    var groupInfos = groupIdInfo.Split('_');
                    if (groupInfos.Length == 2)
                    {
                        int.TryParse(groupInfos[0], out cid);
                        int.TryParse(groupInfos[1], out pid);
                    }
                }

                UniformConfigFactory.RegisterConfig(urlPath, cid, pid);
            }
            return app;
        }
    }
}
