﻿using System.ComponentModel;

namespace Siger.WeComApi.Core.Enum.ModuleEnum
{
    /// <summary>
    /// Config module, start from 2000000
    /// </summary>
    public enum ConfigEnum
    {
        [Description("用户名或密码错误")]
        LoginError = 2000000,

        [Description("重新登录信息不正确")]
        ReLoginFailed,
        [Description("用户未找到")]
        UserNotFound,
        [Description("项目用户未找到")]
        ProjectUserNotFound,
        [Description("项目未找到")]
        ProjectNotFound,
        [Description("Token未找到")]
        TokenIsEmpty,
        [Description("登出信息未找到")]
        EncryptedDataIsEmpty,
        [Description("登出失败")]
        LogoutFailed,
        //file operation
        [Description("文件名未找到")]
        FileNameIsEmpty = 2010000,
        [Description("下载目录未找到")]
        DirectoryNotFound,
        [Description("模板文件未找到")]
        TemplateFileNotFound,
        [Description("模板文件未配置")]
        TemplateFileNotConfig,

        [Description("上传文件为空")]
        UploadFileNotFound,
        [Description("上传的不是Excel文件")]
        IsNotExcelFile,
        [Description("导入失败")]
        ImportFailed,
        [Description("获取用户信息失败")]
        GetTokenInfoError,  //登录时redis中存储的pid、uid

        [Description("产线层级为空")]
        UserLevelNull,
        [Description("已绑定子系统或部件")]
        MachineAlreadyBind,
        [Description("设备属性未找到")]
        MachineAttributionNotFound,
        [Description("设备未找到")]
        MachineNotFound,
        [Description("导入的设备属性不正确")]
        MachineAttributionError,
        [Description("当前设备属性不能重复导入")]
        MachineAttributionInvalid,
        [Description("父级设备未找到")]
        ParentMachineNotFound,
        [Description("工站未找到")]
        StationNotFound,
        [Description("当前设备无法触发安灯")]
        AndonCanNotTrigger,
        [Description("当前设备已绑定工位，无法删除")]
        MahcineCanNotDelete,
        [Description("物料不存在父级")]
        PnParentNotfound,
        [Description("该日期不能调整班次")]
        CannotModifyShift,
        [Description("产品未找到")]
        ProductNotFound,
        [Description("工序已经使用不能修改")]
        RouteisUseCanNotUpdate,
        [Description("工序已经产生新版本不能修改")]
        RouteHasNewVersionCanNotUpdate,
        [Description("已关联生产工单，不支持删除")]
        ProductCanNotDel,
        [Description("工艺过程名称已经存在")]
        CraftProcessisExist,
        [Description("工艺过程名称不能为空")]
        CraftProcessNameNotNull,
        [Description("工艺过程未找到")]
        CraftProcessNotFound,
        [Description("该版本已存在，不可保存版本")]
        VersionHasExist,
        [Description("该工艺版本已有工单绑定下发，不可删除")]
        ProductRouteCanNotDel,
        [Description("工艺版本不能全部禁用")]
        RouteCanNotDisable,
        [Description("工艺版本只能设置一个为默认")]
        RouteOnlySetOneDefault,
        [Description("工艺版本缺少默认版本")]
        RouteVersionLessDefaultVersion,
        [Description("工艺版本为默认版本不能删除,请切换版本进行删除")]
        RouteIsDefaultCanNotDel,
        [Description("技能名称不能为空")]
        SkillNameCanNotNull,
        [Description("部门不能为空")]
        SectionsCanNotNull,
        [Description("岗位不能为空")]
        PostsCanNotNull,
        [Description("技能类型未找到")]
        SkillTypeNotFound,
        [Description("技能等级不能为空")]
        SkillLevelNotNull,
        [Description("员工不能为空")]
        EmployeeNotNull,
        [Description("员工技能未维护")]
        EmploySkillNotMaintain,
        [Description("员工未找到")]
        EmployeeNotFound,
        [Description("技能名称已存在")]
        SkillNameisExist,
        [Description("该员工的该技能已经维护")]
        EmployeeSkillisExist,
        [Description("相同员工的相同技能只能添加一次")]
        EmployeeSkillisRepetition,
        [Description("技能类型已经使用，不能删除")]
        SkillTypeCanNotDel,
        [Description("技能等级错误")]
        SkillLevelError
    }

    public enum ClientType
    {
        [Description("西格数据刀具报警管理系统")]
        Lamp = 1,
        [Description("西格数据线边柜管理系统")]
        TlmStorage
    }

    public enum MachineCategory
    {
        [Description("NC设备")]
        NC = 1,

        [Description("非NC设备")]
        NNC
    }
    public enum MachineNodeName
    {
        [Description("入固")]
        Create = 1,
        [Description("维修")]
        Repair,
        [Description("维护")]
        Maintenance,
        [Description("移动")]
        Move,
        [Description("委外")]
        Outsourcing,
        [Description("报废")]
        Scrap,
        [Description("其他")]
        Other,
    }
    public enum ComboxItem
    {
        [Description("产品")]
        Product = 1,
        [Description("物料")]
        Material = 2
    }

    /// <summary>
    /// 消息推送层级设置mode
    /// </summary>
    public enum ReportModeEnum
    {
        [Description("KPI推送")]
        Kpi,
        [Description("TPM-AM")]
        AM = 1,
        [Description("TPM-PM")]
        PM = 2,
        [Description("QMS推送")]
        Qms = 10,
    }

    /// <summary>
    /// 工序控制类型
    /// </summary>
    public enum RouteType
    {
        [Description("不限制")]
        NotLimit = 1,
        [Description("精确控制")]
        ExactControl
    }
}
