﻿using System.Collections.Generic;


namespace Siger.WeComApi.Common.ExcelImport
{
    public class LevelPlanList : ImportBase
    {
        [ExcelColumn("设备位置")]
        [DonnetCreate]
        [DonnetValidate]
        public string Location { get; set; }

        [ExcelColumn("设备")]
        public string machine { get; set; }

        [ExcelColumn("项目内容")]
        public string content { get; set; }

        [ExcelColumn("维护类型 1->AM；2->PM")]
        public int mode { get; set; }//1->L1；2->L2；3->L3

        [ExcelColumn("1->勾选确定型；2->数值记录型")]
        public int value_type { get; set; }

        [ExcelColumn("单位")]
        public string unit { get; set; }

        [ExcelColumn("上限")]
        public string up_limit { get; set; }

        [ExcelColumn("下限")]
        public string lower_limit { get; set; }

        [ExcelColumn("重要度1->高；2->中；3->低")]
        public int severity_level { get; set; }//项目分类1->润滑；2->检查；3->紧缩；4->清洁；5->调整；6->更换

        [ExcelColumn("失效模式")]
        public string failure_mode { get; set; }

        [ExcelColumn("计划用时（分钟）")]
        public int standard_time { get; set; }

        [ExcelColumn("1->一直执行；2->按日期范围执行；3->按次数执行")]
        public int date_rang { get; set; }

        [ExcelColumn("一直执行/日期范围/次数")]
        public string instruction_time { get; set; }

        [ExcelColumn("执行周期 1-天 7-周 14-两周 30-月 60-两月 90-季度 180-半年 365-年")]
        public int instruction_cycle { get; set; }

        [ExcelColumn("执行人")]
        public string name { get; set; }

        [ExcelColumn("开始执行时间")]
        public string first_instruction_time { get; set; }

        [ExcelColumn("备注")]
        public string remark { get; set; }
    }

    public class LevelPlanListSkf : ImportBase
    {
        [ExcelColumn("设备id")]
        public int machine { get; set; }

        [ExcelColumn("项目内容")]
        public string content { get; set; }

        [ExcelColumn("维护类型 1->AM；2->PM；3->CMP")]
        public int mode { get; set; }//

        [ExcelColumn("1->勾选确定型；2->数值记录型")]
        public int value_type { get; set; }

        [ExcelColumn("单位")]
        public string unit { get; set; }

        [ExcelColumn("上限")]
        public string up_limit { get; set; }

        [ExcelColumn("下限")]
        public string lower_limit { get; set; }

        [ExcelColumn("项目分类 1->润滑；2->检查；3->紧缩；4->清洁；5->调整；6->更换；10->电气；11->机械；12->TS；13->设施")]
        public int severity_level { get; set; }//项目分类

        [ExcelColumn("计划用时（分钟）")]
        public int standard_time { get; set; }

        [ExcelColumn("1->一直执行；2->按日期范围执行；3->按次数执行")]
        public int date_rang { get; set; }

        [ExcelColumn("一直执行/日期范围/次数")]
        public string instruction_time { get; set; }

        [ExcelColumn("执行周期 1-天 7-周 14-两周 30-月 60-两月 90-季度 180-半年 365-年")]
        public int instruction_cycle { get; set; }

        [ExcelColumn("执行人")]
        public string name { get; set; }

        [ExcelColumn("开始执行时间")]
        public string first_instruction_time { get; set; }

        [ExcelColumn("备注")]
        public string remark { get; set; }

        [ExcelColumn("维护工具")]
        public string maintain_tool { get; set; }

        [ExcelColumn("维护备件")]
        public string maintain_sparepart { get; set; }

        [ExcelColumn("失效模式")]
        public string faultmode { get; set; }
    }

    public class LevelPlanTemplate : ImportBase
    {
        [ExcelColumn("产线结构")]
        public List<string> sections { get; set; } = new List<string>();

        [ExcelColumn("设备")]
        public string machine { get; set; }

        [ExcelColumn("项目内容")]
        public string content { get; set; }

        [ExcelColumn("维护类型 1->AM；2->PM")]
        public int mode { get; set; }//1->L1；2->L2；3->L3

        [ExcelColumn("1->勾选确定型；2->数值记录型")]
        public int value_type { get; set; }

        [ExcelColumn("单位")]
        public string unit { get; set; }

        [ExcelColumn("上限")]
        public string up_limit { get; set; }

        [ExcelColumn("下限")]
        public string lower_limit { get; set; }

        [ExcelColumn("重要度1->高；2->中；3->低")]
        public int severity_level { get; set; }//1->润滑；2->检查；3->紧缩；4->清洁；5->调整；6->更换

        [ExcelColumn("失效模式")]
        public string failure_mode { get; set; }

        [ExcelColumn("计划用时（分钟）")]
        public int standard_time { get; set; }

        [ExcelColumn("1->一直执行；2->按日期范围执行；3->按次数执行")]
        public int date_rang { get; set; }

        [ExcelColumn("一直执行/日期范围/次数")]
        public string instruction_time { get; set; }

        [ExcelColumn("执行周期 1-天 7-周 14-两周 30-月 60-两月 90-季度 180-半年 365-年")]
        public int instruction_cycle { get; set; }

        [ExcelColumn("执行人")]
        public string name { get; set; }

        [ExcelColumn("开始执行时间")]
        public string first_instruction_time { get; set; }

        [ExcelColumn("备注")]
        public string remark { get; set; }
    }

    public class LevelPlanTemplateSkf : ImportBase
    {
        [ExcelColumn("产线结构")]
        public List<string> sections { get; set; } = new List<string>();

        [ExcelColumn("设备")]
        public string machine { get; set; }

        [ExcelColumn("项目内容")]
        public string content { get; set; }

        [ExcelColumn("维护类型 1->L1；2->L2；3->L3")]
        public int mode { get; set; }//

        [ExcelColumn("1->勾选确定型；2->数值记录型")]
        public int value_type { get; set; }

        [ExcelColumn("单位")]
        public string unit { get; set; }

        [ExcelColumn("上限")]
        public string up_limit { get; set; }

        [ExcelColumn("下限")]
        public string lower_limit { get; set; }

        [ExcelColumn("项目分类 1->润滑；2->检查；3->紧缩；4->清洁；5->调整；6->更换")]
        public int severity_level { get; set; }//

        [ExcelColumn("失效模式")]
        public string failure_mode { get; set; }

        [ExcelColumn("计划用时（分钟）")]
        public int standard_time { get; set; }

        [ExcelColumn("1->一直执行；2->按日期范围执行；3->按次数执行")]
        public int date_rang { get; set; }

        [ExcelColumn("一直执行/日期范围/次数")]
        public string instruction_time { get; set; }

        [ExcelColumn("执行周期 1-天 7-周 14-两周 30-月 60-两月 90-季度 180-半年 365-年")]
        public int instruction_cycle { get; set; }

        [ExcelColumn("执行人")]
        public string name { get; set; }

        [ExcelColumn("开始执行时间")]
        public string first_instruction_time { get; set; }

        [ExcelColumn("备注")]
        public string remark { get; set; }

        [ExcelColumn("维护工具")]
        public string maintain_tool { get; set; }

        [ExcelColumn("维护备件")]
        public string maintain_sparepart { get; set; }

        [ExcelColumn("命中项")]
        public string hit_item { get; set; }

        [ExcelColumn("维护方法")]
        public string maintain_method { get; set; }
    }

    public class LevelPlanListForExport : ImportBase
    {
        [ExcelColumn("设备位置")]
        public string Location { get; set; }

        [ExcelColumn("设备")]
        public string machine { get; set; }

        [ExcelColumn("项目内容")]
        public string content { get; set; }

        [ExcelColumn("维护类型 1->AM；2->PM；3->CMP")]
        public string mode { get; set; }

        [ExcelColumn("1->勾选确定型；2->数值记录型")]
        public string value_type { get; set; }

        [ExcelColumn("单位")]
        public string unit { get; set; }

        [ExcelColumn("上限")]
        public string up_limit { get; set; }

        [ExcelColumn("下限")]
        public string lower_limit { get; set; }

        [ExcelColumn("项目分类 1->润滑；2->检查；3->紧缩；4->清洁；5->调整；6->更换；10->电气；11->机械；12->TS；13->设施")]
        public string severity_level { get; set; }

        [ExcelColumn("失效模式")]
        public string failure_mode { get; set; }

        [ExcelColumn("计划用时（分钟）")]
        public int standard_time { get; set; }

        [ExcelColumn("1->一直执行；2->按日期范围执行；3->按次数执行")]
        public string date_rang { get; set; }

        [ExcelColumn("一直执行/日期范围/次数")]
        public string instruction_time { get; set; }

        [ExcelColumn("执行周期 1-天 7-周 14-两周 30-月 60-两月 90-季度 180-半年 365-年")]
        public string instruction_cycle { get; set; }

        [ExcelColumn("执行人")]
        public string name { get; set; }

        [ExcelColumn("实际用时")]
        public int actualtime { get; set; }

        [ExcelColumn("执行时间")]
        public string first_instruction_time { get; set; }
        [ExcelColumn("工单号")]
        public string work_order { get; set; }

        [ExcelColumn("备注")]
        public string remark { get; set; }
        [ExcelColumn("状态")]
        public string state { get; set; }
    }
}
