﻿using Microsoft.AspNetCore.Mvc;

namespace Siger.ApiCommon.Result
{
    public class PagedObjectResult: ActionResult
    {
        public object data { get; set; }

        public int total { get; set; }

        public int page { get; set; }

        public int pagesize { get; set; }

        public PagedObjectResult(object value, int totalValue, int pageValue = 1, int pagesizeValue = 10)
        {
            data = value;
            total = totalValue;
            page = pageValue;
            pagesize = pagesizeValue;
        }
    }

    public class PagedLongTotalObjectResult : ActionResult
    {
        public object data { get; set; }

        public long total { get; set; }

        public int page { get; set; }

        public int pagesize { get; set; }

        public PagedLongTotalObjectResult(object value, long totalValue, int pageValue = 1, int pagesizeValue = 10)
        {
            data = value;
            total = totalValue;
            page = pageValue;
            pagesize = pagesizeValue;
        }
    }
}
