﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Core.Domain.Data
{
    public class AlarmStatistFinalResult
    {
        public AlarmStatistResult data1 { get; set; }
        public AlarmStatistNameResult2 data2 { get; set; }
    }
    public class AlarmStatistAll
    {
        public string time { get; set; }
        public List<ResponseToolAlarmStatisticsInfo> data { get; set; }
    }
    public class AlarmStatistResult: AlarmStatistBase
    {
        public List<string> datetime { get; set; }
        public AlarmStatistResult()
        {
            datetime = new List<string>();
        }
    }
    public class AlarmStatistNameResult : AlarmStatistBase
    {
        public List<string> name { get; set; }
        public AlarmStatistNameResult()
        {
            name = new List<string>();
        }
    }
    public class AlarmStatistNameResult2
    {
        public List<string> name { get; set; }
        public int zl { get; set; }
        public int sm { get; set; }
        public int ms { get; set; }
        public int bz { get; set; }
        public int dd { get; set; }
        public AlarmStatistNameResult2()
        {
            name = new List<string>();
        }
     
    }
    public class AlarmStatistBase
    {
        public List<int> zl { get; set; }
        public List<int> sm { get; set; }
        public List<int> ms { get; set; }
        public List<int> bz { get; set; }
        public List<int> dd { get; set; }
        public AlarmStatistBase()
        {
            zl = new List<int>();
            sm = new List<int>();
            ms = new List<int>();
            bz = new List<int>();
            dd = new List<int>();
        }
    }

    public class ResponseToolAlarmStatisticsInfo : IComparable
    {
        public string name { get; set; }
        public int value { get; set; }
        public int alarm_grade { get; set; }
        //public string color { get; set; }

        public int CompareTo(object other)
        {
            if (null == other)
                return 1;
            return this.value.CompareTo(((ResponseToolAlarmStatisticsInfo)other).value);
        }
    }
}
