﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Core.Domain.Data
{
    public class MaterialType : EntityBase
    {
        public int id { get; set; }

        public string name { get; set; }

        public string pname { get; set; }

        /// <summary>
        /// 简码
        /// </summary>
        public string tcode { get; set; }

        public int pid { get; set; }
    }

    public class MaterialTypeTree
    {
        public int id { get; set; }

        public string name { get; set; }

        public int pid { get; set; }

        public bool open { get; set; }

        public List<MaterialTypeTree> children { get; set; }

        public void AddChildren(MaterialTypeTree node)
        {
            if (children == null)
            {
                children = new List<MaterialTypeTree>();
            }
            children.Add(node);
        }
    }

    public class ResponseMaterialTypeChildren
    {
        public IEnumerable<MaterialTypeTree> children { get; set; }

        public ResponseMaterialTypeChildren(IEnumerable<MaterialTypeTree> tree)
        {
            children = tree;
        }
    }
}
