﻿namespace Siger.WeComApi.Core.Domain.Data.Tpm
{
    public class LevelByRepair : EntityBase
    {
        public int id { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int machineid { get; set; } = 0;

        /// <summary>
        /// 
        /// </summary>
        public int createtime { get; set; } = 0;

        /// <summary>
        /// project_machine_fault.id 故障内容 如果为0，表示其他
        /// </summary>
        public int faultid { get; set; } = 0;

        /// <summary>
        /// 项目id
        /// </summary>
        public int projectid { get; set; }

        /// <summary>
        /// 创建人的mid
        /// </summary>
        public int mid { get; set; } = 0;

        /// <summary>
        /// 如果fault为0，则填写此项。 其他故障原因
        /// </summary>
        public string remark { get; set; } = string.Empty;

        /// <summary>
        /// 1待接单，2已接单;待签到，3待维修，4签到;待复线，5维修完成,待反馈，6已完成，7已完成，0->删除
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 存放图片的url，用逗号隔开
        /// </summary>
        public string images { get; set; } = string.Empty;

        /// <summary>
        /// 接单人的mid
        /// </summary>
        public int takemid { get; set; } = 0;

        /// <summary>
        /// 拒绝维修信息
        /// </summary>
        public string refuse_repair_info { get; set; } = string.Empty;

        /// <summary>
        /// 签到人的mid
        /// </summary>
        public int signmid { get; set; } = 0;

        /// <summary>
        /// 接单时间
        /// </summary>
        public int taketime { get; set; } = 0;

        /// <summary>
        /// 维修签到时间
        /// </summary>
        public int signtime { get; set; } = 0;

        /// <summary>
        /// 
        /// </summary>
        public int repairmid { get; set; } = 0;

        /// <summary>
        /// (完成后)提交信息的时间
        /// </summary>
        public int repairtime { get; set; } = 0;

        /// <summary>
        /// 复线操作人mid
        /// </summary>
        public int checkmid { get; set; } = 0;

        /// <summary>
        /// 复线时间
        /// </summary>
        public int checktime { get; set; } = 0;

        /// <summary>
        /// 复线拒绝的原因
        /// </summary>
        public string refuse_recovery_info { get; set; } = string.Empty;

        /// <summary>
        /// 故障现象描述
        /// </summary>
        public string fault_description { get; set; } = string.Empty;

        /// <summary>
        /// 拒绝复线上次工单id
        /// </summary>
        public int last_repair_record { get; set; } = 0;

        /// <summary>
        /// 故障现象描述图片
        /// </summary>
        public string fault_desc_img { get; set; } = string.Empty;

        /// <summary>
        /// 维修排查过程描述
        /// </summary>
        public string repair_process { get; set; } = string.Empty;

        /// <summary>
        /// 故障原因 _project_machine_fault
        /// </summary>
        public int real_faultid { get; set; } = 0;

        /// <summary>
        /// 故障原因描述
        /// </summary>
        public string real_faultid_desc { get; set; } = string.Empty;

        /// <summary>
        /// 所用备件(id) 如果多个用逗号隔开
        /// </summary>
        public string sparepartid { get; set; } = string.Empty;

        /// <summary>
        /// 维修过程备注（其他备件名称等）
        /// </summary>
        public string repair_remark { get; set; } = string.Empty;

        /// <summary>
        /// 0=>未停线 1=>停线
        /// </summary>
        public int offlinestatus { get; set; } = 0;

        /// <summary>
        /// 完成维修mid
        /// </summary>
        public int completemid { get; set; } = 0;

        /// <summary>
        /// 完成维修时间
        /// </summary>
        public int completetime { get; set; } = 0;

        /// <summary>
        /// 关联出库单号
        /// </summary>
        public string sparepartout { get; set; } = string.Empty;

        /// <summary>
        /// 工单当前异常上报等级
        /// </summary>
        public int report_level { get; set; } = 0;

        /// <summary>
        /// 参与维修人
        /// </summary>
        public string add_repairmid { get; set; } = string.Empty;
    }

    public class SpaceTime
    {
        public int type { get; set; }

        public int start_level { get; set; }

        public int space_time { get; set; }
    }
}
