﻿using System;

namespace Siger.WeComApi.Core.Domain.Entity
{
    public class siger_project_product_route : ConfigEntityBase
    {
        public string name { get; set; } = string.Empty;

        public int productId { get; set; } = 0;

        /// <summary>
        /// 工站id--弃用
        /// </summary>
        public int sectionId { get; set; } = 0;

        /// <summary>
        /// 产线id--弃用
        /// </summary>
        public int levelId { get; set; } = 0;

        /// <summary>
        /// 工序顺序号
        /// </summary>
        public int serialNumber { get; set; } = 0;

        /// <summary>
        /// 工序路径编号--预留
        /// </summary>
        public string route_code { get; set; } = string.Empty;

        /// <summary>
        /// 设备id
        /// </summary>
        public int machine_type { get; set; } = 0;

        /// <summary>
        /// 工序说明
        /// </summary>
        public string description { get; set; } = string.Empty;

        /// <summary>
        /// 额定工时
        /// </summary>
        public double working_hours { get; set; } = 0;
        /// <summary>
        /// 泡沫工时
        /// </summary>
        public double foam_hours { get; set; }
        /// <summary>
        /// 准备工时
        /// </summary>
        public double prepare { get; set; } = 0;

        /// <summary>
        /// 创建人
        /// </summary>
        public int create_usermid { get; set; } = 0;

        public DateTime addTime { get; set; } = DateTime.Now;

        public int projectId { get; set; }
        /// <summary>
        /// 是否为并行工序 0为否 1为是
        /// </summary>
        public int parallelProcess { get; set; }

        /// <summary>
        /// 标准工序id
        /// </summary>
        public int standard_id { get; set; }

        /// <summary>
        /// 控制类型:1无限制 2精确控制
        /// </summary>
        public int control_type { get; set; }

        /// <summary>
        /// 工艺版本 初始 V1.0
        /// </summary>
        public double version { get; set; }

        /// <summary>
        /// 流转类型  1手动 2自动
        /// </summary>
        public int transfer_type { get; set; }

        /// <summary>
        /// 工序类型 1自助 2外协 3辅助工序
        /// </summary>
        public int route_type { get; set; }

        /// <summary>
        /// 工艺过程
        /// </summary>
        public string craft_process { get; set; }

        /// <summary>
        /// 是否是默认版本 1是2否
        /// </summary>
        public int is_default { get; set; }

        /// <summary>
        /// 来源于产品创建时创建的工序(1是 2否)
        /// </summary>
        public int source_product { get; set; } = 2;

        /// <summary>
        /// 是否禁用 1是2否
        /// </summary>
        public int is_disable { get; set; } = 2;
    }
}
