﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Siger.WeComApi.Core.Dto.Request
{
    public class RequestRouteGroup
    {
        public string group_name { get; set; }


        /// <summary>
        /// 归属标准工序列表
        /// </summary>
        public List<RouteGroupStandard> standardList { get; set; }
    }

    /// <summary>
    /// 工序组-标准工序关联表
    /// </summary>
    public class RouteGroupStandard
    {
        /// <summary>
        /// 工序组id
        /// </summary>
        public int group_id { get; set; } = 0;

        /// <summary>
        /// 标准工序id
        /// </summary>
        public int standard_id { get; set; } = 0;

        /// <summary>
        /// 工序序号
        /// </summary>
        public string group_no { get; set; }

        /// <summary>
        /// 标准工序名称
        /// </summary>
        public string standard_name { get; set; }

        /// <summary>
        /// 工序说明
        /// </summary>
        public string description { get; set; }

        /// <summary>
        /// 额定工时
        /// </summary>
        public double working_hours { get; set; }

        /// <summary>
        /// 准备工时
        /// </summary>
        public double foam_hours { get; set; }

        /// <summary>
        /// 并行工序
        /// </summary>
        public int parallelProcess { get; set; } = 0;

        /// <summary>
        /// 控制类型:1无限制 2精确控制
        /// </summary>
        public int control_type { get; set; }
        /// <summary>
        /// 流转类型  1手动 2自动
        /// </summary>
        public int transfer_type { get; set; }

        /// <summary>
        /// 工艺过程
        /// </summary>
        public string craft_process { get; set; }

        public int route_type { get; set; }
    }

    public class RequestModifyRouteGroup : RequestRouteGroup
    {
        public int id { get; set; }

    }
}
