﻿using Siger.CommonUtil;
using System;
using System.IO;

namespace Siger.WeComApi.Common
{
    /// <summary>
    /// 配置管理
    /// </summary>
    public class ConfigManager
    {
        private static IConfig _config;

        /// <summary>
        /// Construct the ConfigManager by given content.
        /// </summary>
        static ConfigManager()
        {
            if (!ConfigFactory.IsInit)
            {
                var filePath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Setting", "CommonSetting.ini");
                if (!File.Exists(filePath))
                {
                    throw new FileNotFoundException("can not found CommonSetting.ini.");
                }
                using (var reader = new StreamReader(filePath))
                {
                    var content = reader.ReadToEnd();
                    ConfigFactory.InitConfigByContent(content);
                    _config = ConfigFactory.GetConfig();
                }
            }
            else
            {
                _config = ConfigFactory.GetConfig();
            }
        }


        /// <summary>
        /// Get one item value of one section.
        /// </summary>
        /// <typeparam name="T">The type of return value.</typeparam>
        /// <param name="section">the section's name</param>
        /// <param name="key">The key's name</param>
        /// <param name="defaultValue">The default value of the T</param>
        /// <returns></returns>
        public static T GetValue<T>(string section, string key, T defaultValue)
        {
            return _config.GetSectionKeyValue<T>(section, key, defaultValue);
        }

        public static T GetSection<T>(string section)
        {
            return _config.GetSectionObj<T>(section);
        }
    }
}
