﻿using Microsoft.AspNetCore.Mvc;
using Senparc.Weixin.Work.Tencent;
using Microsoft.AspNetCore.Http;
using Siger.CommonUtil.Logging;
using System;
using Siger.WeComApi.WebApi.Controllers;
using Siger.WeComApi.Core.Biz;
using Siger.WeComApi.Common.Filter;
using Siger.WeComApi.Common.CommonModels;
using Siger.WeComApi.Common.Enums;
using Siger.WeComApi.Core.Dto.Response;

namespace Siger.ApiTPM.Controllers
{
    public class UserController : BaseController
    {
        private readonly ISigerLogger<UserController> _logger;
        private readonly ISigerWeComThirdService _sigerWeComThirdService;

        public UserController(ISigerLogger<UserController> logger, ISigerWeComThirdService sigerWeComThirdService)
        {
            this._logger = logger;
            this._sigerWeComThirdService = sigerWeComThirdService;
        }

        /// <summary>
        /// 获取访客身份信息
        /// </summary>
        /// <returns></returns>
        [NoTokenValidateFilter]
        public ResponseBase GetUserInfo(string code)
        {
            string result = "success";
            try
            {
                ResponseWeComUser userInfo = _sigerWeComThirdService.GetUserInfo(code);
                return new ResponseBase(1, 1, userInfo);
            }
            catch (Exception ex)
            {
                result = "企微回调异常：" + ex.Message;
                _logger.Error(result);
                return new ResponseBase(0, 1, result);
            }
        }
    }
}
