﻿using Siger.WeComApi.Common.Enums;

namespace Siger.WeComApi.Common.CommonModels
{
    /// <summary>
    /// 请求响应的基本类型
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public class ResponseBase<T> where T : class
    {
        /// <summary>
        /// 请求状态 1：成功 0：失败
        /// </summary>
        public int Ret { get; set; }
        /// <summary>
        /// 消息编码
        /// </summary>
        public int Msg { get; set; }
        /// <summary>
        /// 数据
        /// </summary>
        public T Data { get; set; }
        /// <summary>
        /// 请求响应的基本类型
        /// </summary>
        /// <param name="returnValue">请求状态 1：成功 0：失败</param>
        /// <param name="message">消息编码</param>
        /// <param name="dataobj">数据</param>
        public ResponseBase(int returnValue, int message, T dataobj)
        {
            Ret = returnValue;
            Msg = message;
            Data = dataobj;
        }
        /// <summary>
        /// 请求响应的基本类型
        /// </summary>
        /// <param name="dataobj"></param>
        public ResponseBase(T dataobj)
        {
            Ret = 1;
            Msg = 1;
            Data = dataobj;
        }
    }

    /// <summary>
    /// 请求基类
    /// </summary>
    public class ResponseBase : ResponseBase<object>
    {
        /// <summary>
        /// 请求基类
        /// </summary>
        /// <param name="returnValue">请求状态 1：成功 0：失败</param>
        /// <param name="message">消息编码</param>
        /// <param name="dataobj">数据</param>
        public ResponseBase(int returnValue, int message, object dataobj) : base(returnValue, message, dataobj)
        {

        }

        /// <summary>
        /// 成功
        /// </summary>
        /// <returns></returns>
        public static ResponseBase Success() => new ResponseBase(1, 1, CommonEnum.Succefull);

        /// <summary>
        /// 失败
        /// </summary>
        /// <param name="failCode">失败状态码</param>
        /// <param name="error">失败信息</param>
        /// <returns></returns>
        public static ResponseBase Fail(int failCode, object error = null) => new ResponseBase(0, failCode, error);
    }
}
