﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;
namespace Siger.WeComApi.Core.Enum.ModuleEnum
{
    /// <summary>
    /// Dnc module, start from 5000000
    /// </summary>
    public enum DncEnum
    {
        [Description("DNC服务配置加载失败")] LoadCfgFail = 5000000,
        [Description("DNC服务注册Consul失败")] RegConsulFail,
        [Description("程序内容包含非法编码格式")] InvalidEncoding,
        [Description("设备正在机加工不能切换程序号")]MachineisProcess,
        [Description("设备未在加工不能结束加工")]MachineisNotProcess,
        [Description("设备未在加工")] MachineNotProcess,
    }
    public enum CheckState
    {
        [Description("待审核")] Waiting = 1,
        [Description("已审核")] Checked = 2,
        [Description("被拒绝")] Reject = 3
    }
    public enum CheckInfo
    {
        /// <summary>
        /// 通过
        /// </summary>
        [Description("通过")] OK = 1,
        /// <summary>
        /// 不通过
        /// </summary>
        [Description("不通过")] NOK = 2
    }
    public enum ChangeProgramType
    {
        Add = 1,
        Update,
        Delete
    }
    public enum actionType
    {
        /// <summary>
        /// 上传
        /// </summary>
        Upload,
        /// <summary>
        /// 下载
        /// </summary>
        Download,
        /// <summary>
        /// 删除
        /// </summary>
        Delete
    }
    public enum progromType
    {
        [Description("主程序")]
        Main = 1,
        [Description("子程序")]
        Son = 2
    }

    public enum DNCMachineStatus
    {
        [Description("开始加工")]
        Start = 1,
        [Description("暂停加工")]
        Pause,
        [Description("结束加工")]
        Finish
    }
}
