﻿using Siger.WeComApi.Common.ExcelImport;

namespace Siger.WeComApi.Common.ExcelImport
{
    public class UserList: ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        [DonnetCreate]
        public int No { get; set; }

        [ExcelColumn("姓名*")]
        [EmptyValidate("NameIsEmpty")]
        public string Name { get; set; }

        [ExcelColumn("性别*")]
        public string Sex { get; set; }

        [ExcelColumn("部门*")]
        [EmptyValidate("SectionIsEmpty")]
        public string Section { get; set; }

        [ExcelColumn("岗位*")]
        [EmptyValidate("UsergroupIsEmpty")]
        public string Usergroup { get; set; }

        [ExcelColumn("手机*")]
        [EmptyValidate("MobileIsEmpty")]
        //[RegularExpressionValidate("[1][3,4,5,7,8][0-9]{9}$", "MobileIsInvalid")]
        public string Mobile { get; set; }

        [ExcelColumn("固话")]
        public string Fixed_line { get; set; }

        [ExcelColumn("邮箱")]
        [RegularExpressionValidate(@"\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$", "EmailIsInvalid")]
        public string Email { get; set; }
        
        [ExcelColumn("入职日期")]
        public string Create_time { get; set; }

        [ExcelColumn("密码*")]
        [DonnetExport]
        public string Password { get; set; }

        [ExcelColumn("工号*")]
        public string Work_code { get; set; }

        [ExcelColumn("IC卡号")]
        public string Rank { get; set; }

        [ExcelColumn("成本中心")]
        public string CostCenter { get; set; }
    }
}
