﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Common.ExcelImport
{
    public class WorkingHourList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        [DonnetExport]
        public int No { get; set; }

        /// <summary>
        /// 工号
        /// </summary>
        [ExcelColumn("工号")]
        public string WorkCode { get; set; }

        [ExcelColumn("姓名")]
        public string Name { get; set; }

        [ExcelColumn("订单号")]
        public string OrderCode { get; set; }

        [ExcelColumn("工单号")]
        public string OrderNumber { get; set; }

        [ExcelColumn("工令单号")]
        public string Abscissa { get; set; }

        [ExcelColumn("工序名称")]
        public string RouteName { get; set; }

        [ExcelColumn("工位")]
        public string Station { get; set; }

        [ExcelColumn("产品名称")]
        public string ProductName { get; set; }

        [ExcelColumn("产品图纸号")]
        public string DrawingCode { get; set; }

        [ExcelColumn("报工时间")]
        public string ReportTime { get; set; }

        [ExcelColumn("OK数量")]
        public int Ok { get; set; }

        [ExcelColumn("NOK数量")]
        public int NOK { get; set; }

        [ExcelColumn("工时")]
        public string WorkingHour { get; set; }

        //[ExcelColumn("准终工时(分钟)")]
        //public string Prepare { get; set; }

        //[ExcelColumn("工时合计(分钟)")]
        //public string Total { get; set; }
    }

    public class WorkingHourUserList : WorkingHourList
    {
        //[ExcelColumn("姓名")]
        //public string Name { get; set; }

        //[ExcelColumn("工号")]
        //public string WorkCode { get; set; }

        [ExcelColumn("班组")]
        public string WorkGroup { get; set; }
    }
}
