﻿using Microsoft.AspNetCore.Builder;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.OpenApi.Models;
using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;

namespace Siger.WeComApi.Common.Helpers
{
    public static class Swagger
    {
        private readonly static List<string> xmlFiles = new List<string> {
            "Siger.WeComApi.WebApi.xml",
            "Siger.WeComApi.Core.xml"
        };

        public static void AddSwagger(this IServiceCollection services)
        {
            string strLable = string.Empty;
            string strRepository = string.Empty;
            services.AddSwaggerGen(c =>
            {
                c.SwaggerDoc("v1", new OpenApiInfo
                {
                    Version = "v1",
                    Title = AppConstants.AppID,
                    Description = $"{AppConstants.AppID} API Document",
                    TermsOfService = null,
                    Contact = new OpenApiContact
                    {
                        Name = AppConstants.AppID,
                        Url = null,
                        Email = ""
                    }
                });

                var basePath = Path.GetDirectoryName(typeof(Swagger).Assembly.Location);
                // 获取xml文件名
                var xmlFile = $"{Assembly.GetExecutingAssembly().GetName().Name}.xml";
                // 获取xml文件路径
                var xmlPath = Path.Combine(basePath, xmlFile);

                // 添加控制器层注释，true表示显示控制器注释
                c.IncludeXmlComments(xmlPath, true);
                if (xmlFiles.Count > 0)
                {
                    foreach (var xmlfile in xmlFiles)
                    {
                        // 获取xml文件路径
                        var thisXmlPath = Path.Combine(basePath, xmlfile);
                        c.IncludeXmlComments(thisXmlPath, true);
                    }
                }
            });
        }
        public static void RegisterSwagger(this IApplicationBuilder app)
        {
            app.UseSwagger();
            app.UseSwaggerUI(c =>
            {
                c.SwaggerEndpoint("/swagger/v1/swagger.json", "API Demo v1");
            });
        }
    }
}
