﻿using AutoMapper;
using Siger.WeComApi.Core.Domain.Data;
using Siger.WeComApi.Core.Domain.Entity;
using Siger.WeComApi.Core.Dto;
using Siger.WeComApi.Core.Dto.Request;
using Siger.WeComApi.Core.Dto.Response;
using System.Collections.Generic;

namespace Siger.WeComApi.Core.AutoMap
{
    /// <summary>
    /// 用户对象映射配置
    /// </summary>
    public class MapProfile : Profile
    {
        /// <summary>
        /// 构造
        /// </summary>
        public MapProfile()
        {
            this.CreateMap<RegisterDto, siger_company_project_register>().ReverseMap();

            this.CreateMap<RequestUpdateCompany, ResponseGetCompanyList>().ReverseMap();

            this.CreateMap<CompanyDto, siger_company>().ReverseMap();

            this.CreateMap<ResponseIdTitle, IdTitle>().ReverseMap();

            this.CreateMap<ResponseGetProjectLevel, siger_project_level>().ReverseMap();

            this.CreateMap<ProjectLevelDto, ResponseGetProjectLevel>().ReverseMap();

            this.CreateMap<LevelSectionTree, siger_project_level_section>().ReverseMap();

            this.CreateMap<List<ResponseMachineNode>, List<siger_project_machine_node>>().ReverseMap();

            this.CreateMap<ResponseGetProject, Project>().ReverseMap();

            this.CreateMap<ResponseGetProjectTitle,siger_project>().ReverseMap();

            this.CreateMap<Project, siger_project>().ReverseMap();

            this.CreateMap<ResponseUserPower, siger_user_power>().ReverseMap();
        }
    }
}
