﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Siger.WeComApi.Core.Dto.Request
{
    public class RequestAddProduct
    {
        [Required(ErrorMessage = "NameIsEmpty")]
        public string name { get; set; }

        public string code { get; set; }

        [Required(ErrorMessage = "DrawingcodeIsEmpty")]
        public string drawingcode { get; set; }

        public string remark { get; set; }

        public int createtime { get; set; }
        public string image { get; set; }

        /// <summary>
        /// 工序组id
        /// </summary>
        public int group_id { get; set; }

        public List<RequestRouteInfo> routes { get; set; } = new List<RequestRouteInfo>();
    }

    public class RequestUpdateProduct : RequestAddProduct
    {
        [Required(ErrorMessage = "IdIsEmpty")]
        public int id { get; set; }
    }

    public class RequestRouteInfo
    {
        /// <summary>
        /// 工序序号
        /// </summary>
        public int SerialNumber { get; set; }

        /// <summary>
        /// 工序名称
        /// </summary>
        public string RouteName { get; set; }

        /// <summary>
        /// 工序说明
        /// </summary>
        public string RouteDesc { get; set; }

        /// <summary>
        /// 额定工时
        /// </summary>
        public double Timing { get; set; }

        /// <summary>
        /// 控制类型:1无限制 2精确控制
        /// </summary>
        public int ControlType { get; set; }

        /// <summary>
        /// 标准工序id
        /// </summary>
        public int StandardId { get; set; }

        /// <summary>
        /// 工艺过程
        /// </summary>
        public string craft_process { get; set; }

        /// <summary>
        /// 流转类型  1手动 2自动
        /// </summary>
        public int transfer_type { get; set; }

        public int route_type { get; set; }
    }
}
