﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Siger.WeComApi.Common.cache;
using Siger.Middlelayer.Redis.RedisEntities;

namespace Siger.Middlelayer.Redis
{
    public partial class RedisCache
    {
        private const string HostHash = "Hosts";

        public async Task<IEnumerable<HostEntity>> GetHosts()
        {
            var hosts = new List<HostEntity>();
            var allHosts = await CacheUtility.Instance.HGetAllAsync(HostHash);
            foreach (var host in allHosts)
            {
                var cidpid = host.Key.Split(':');
                hosts.Add(new HostEntity
                {
                    Host = cidpid[0],
                    Port = cidpid.Length > 1 ? cidpid[1] : ""
                });
            }

            return hosts;
        }

        public async Task AddHost(HostEntity host)
        {
            var key = $"{host.Host}:{host.Port}";

            await CacheUtility.Instance.SetHashAsync(HostHash, key, 1);
        }

        public async Task DeleteHost(string key)
        {
           await CacheUtility.Instance.DelAsync(HostHash, key);
        }

        /// <summary>
        /// get all allow origins
        /// </summary>
        /// <returns></returns>
        public async Task<List<string>> AllowOrigins()
        {
            var allHosts = await CacheUtility.Instance.HGetAllAsync(HostHash);
            if (allHosts != null)
            {
                return allHosts.Where(q => q.Value == "1").Select(host => host.Key.StartsWith("http") ? host.Key : $"http://{host.Key}").ToList();
            }
            return new List<string>();
        }

    }
}
