﻿
using System.Collections.Generic;

namespace Siger.WeComApi.Common.ExcelImport
{
    /// <summary>
    /// 导出模板
    /// </summary>
    public class InspectionStandardTemplate : ImportBase
    {
        [ExcelColumn("*产品编号")]
        public string productcode { get; set; }

        [ExcelColumn("产品名称")]
        [DonnetCreate]
        [DonnetValidate]
        public string productname { get; set; }

        [ExcelColumn("*检验位置")]
        public string section { get; set; }

        [ExcelColumn("项次")]
        [DonnetCreate]
        [DonnetValidate]
        public int seq { get; set; }

        [ExcelColumn("*检验项目")]
        public string item { get; set; }

        [ExcelColumn("*检验标准")]
        public string standard { get; set; }

        [ExcelColumn("*维护方式")]
        public string value_type { get; set; }

        [ExcelColumn("*值类型")]
        public string value_category { get; set; }

        [ExcelColumn("单位")]
        public string unit { get; set; }

        [ExcelColumn("最小值")]
        public string min_value { get; set; }

        [ExcelColumn("最大值")]
        public string max_value { get; set; }

        [ExcelColumn("*触发安灯")]
        public string trigger_andon { get; set; }

        [ExcelColumn("控制下限")]
        public string lcl { get; set; }

        [ExcelColumn("控制上限")]
        public string ucl { get; set; }

        [ExcelColumn("*缺陷类型")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_category { get; set; }

        [ExcelColumn("*缺陷名称")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_name { get; set; }

        [ExcelColumn("*缺陷代码")]
        public string unhealthy_code { get; set; }

        [ExcelColumn("量具类型")]
        [DonnetCreate]
        [DonnetValidate]
        public string measure_category { get; set; }

        [ExcelColumn("量具名称")]
        [DonnetCreate]
        [DonnetValidate]
        public string measure { get; set; }

        [ExcelColumn("量具编号")]
        public string measure_code { get; set; }

        [ExcelColumn("量具规格")]
        [DonnetCreate]
        [DonnetValidate]
        public string measure_spec { get; set; }

        [ExcelColumn("维护人")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_mid { get; set; }

        [ExcelColumn("维护时间")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_time { get; set; }

        [ExcelColumn("是否送检")]
        public string isinpect { get; set; }

        [ExcelColumn("检验类型")]
        public string inpectcategories { get; set; }

    }


    /// <summary>
    /// 导入模板
    /// </summary>
    public class InspectStandardLevelTemplate : ImportBase
    {
        [ExcelColumn("*产品编号")]
        public string productcode { get; set; }

        [ExcelColumn("*缺陷代码")]
        public string unhealthy_code { get; set; }

        [ExcelColumn("*项次")]
        public string seq { get; set; }

        [ExcelColumn("*是否送检")]
        public string isinpect { get; set; }

        [ExcelColumn("*检验类型")]
        public string inpectcategories { get; set; }

        [ExcelColumn("*检验项目")]
        public string item { get; set; }

        [ExcelColumn("*检验标准")]
        public string standard { get; set; }

        [ExcelColumn("量具编号")]
        public string measure_code { get; set; }

        [ExcelColumn("*维护方式")]
        public string value_type { get; set; }

        [ExcelColumn("*值类型")]
        public string value_category { get; set; }

        [ExcelColumn("单位")]
        public string unit { get; set; }

        [ExcelColumn("最小值")]
        public string min_value { get; set; }

        [ExcelColumn("最大值")]
        public string max_value { get; set; }

        [ExcelColumn("控制下限")]
        public string lcl { get; set; }

        [ExcelColumn("控制上限")]
        public string ucl { get; set; }

        [ExcelColumn("*是否触发安灯")]
        public string trigger_andon { get; set; }
    }

    public class InspectionStandardLevelTemplate : InspectStandardLevelTemplate
    {
        [ExcelColumn("产线结构")]
        public List<string> sections { get; set; } = new List<string>();
    }

    public class InspectionStandards : InspectionStandardLevelTemplate
    {
        public int productid { get; set; }

        public int sectionid { get; set; }

        public int unhealthyid { get; set; }

        public string unhealthyname { get; set; }

        public string item_en { get; set; }


        public string measure_guid { get; set; }

        public string measure_category { get; set; }

        public string measure_spec { get; set; }

        public string measure_name { get; set; }
    }
}
