﻿using Siger.WeComApi.Core.Domain;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Siger.WeComApi.Core.Domain.Entity
{
    /// <summary>
    /// 
    ///</summary>
    [Table("siger_user")]
    public class SigerUser : EntityBase
    {
        /// <summary>
        /// 
        ///</summary>
        [Key]
        [Column("id")]
        public int Id { get; set; }

        /// <summary>
        /// 废弃
        ///</summary>
        [Column("userid")]
        public string Userid { get; set; }

        /// <summary>
        /// 
        ///</summary>
        [Column("password")]
        public string Password { get; set; }

        /// <summary>
        /// 
        ///</summary>
        [Column("nickname")]
        public string Nickname { get; set; }

        /// <summary>
        /// 
        ///</summary>
        [Column("face")]
        public string Face { get; set; }
        
        /// <summary>
        /// 0->男;1->女;2->男变女;3->女变男
        ///</summary>
         [Column("sex")]
         public int Sex { get; set; }

        /// <summary>
        /// 
        ///</summary>
        [Column("email")]
        public string Email { get; set; }
        
        /// <summary>
        /// 0->;未验证 1->;已验证
        ///</summary>
         [Column("email_status")]
         public int EmailStatus { get; set; }

        /// <summary>
        /// 
        ///</summary>
        [Column("mobile")]
        public string Mobile { get; set; }
        
        /// <summary>
        /// 0->未验证 1->已验证
        ///</summary>
         [Column("mobile_status")]
         public int MobileStatus { get; set; }

        /// <summary>
        /// -1->;账号无效 0->待审核; 1 ->正常使用
        ///</summary>
        [Column("status")]
        public int Status { get; set; }

        /// <summary>
        /// 
        ///</summary>
        [Column("jointime")]
        public int Jointime { get; set; }

        /// <summary>
        /// 
        ///</summary>
        [Column("joinip")]
        public string Joinip { get; set; }

        /// <summary>
        /// 
        ///</summary>
        [Column("lastlogintime")]
        public int Lastlogintime { get; set; }
        
        /// <summary>
        /// 0->普通会员 1->开店会员 2->管理员
        ///</summary>
         [Column("type")]
         public int Type { get; set; }

        /// <summary>
        /// 被赞数量
        ///</summary>
        [Column("zan")]
        public int Zan { get; set; }

        /// <summary>
        /// 粉丝数量
        ///</summary>
        [Column("fans")]
        public int Fans { get; set; }

        /// <summary>
        /// 关注数量

        ///</summary>
        [Column("follow")]
        public int Follow { get; set; }

        /// <summary>
        /// 滴辣不沾,微辣,中辣,巨辣,变态辣,重口味
        ///</summary>
        [Column("taste")]
        public string Taste { get; set; }

        /// <summary>
        /// 最多256个汉字，用英文下逗号隔开
        ///</summary>
        [Column("avoid_certain_food")]
        public string AvoidCertainFood { get; set; }

        /// <summary>
        /// 个人简介，理论上最多500个字
        ///</summary>
        [Column("message")]
        public string Message { get; set; }

        /// <summary>
        /// 用户获得积分
        ///</summary>
        [Column("score")]
        public int Score { get; set; }

        /// <summary>
        /// 账户余额（充值用）
        ///</summary>
        [Column("balance")]
        public decimal Balance { get; set; }

        /// <summary>
        /// 生日
        ///</summary>
        [Column("birthday")]
        public int Birthday { get; set; }

        /// <summary>
        /// 真实姓名
        ///</summary>
        [Column("realname")]
        public string Realname { get; set; }

        /// <summary>
        /// 用户权限JSON字符串 如：{&quot;version&quot;:&quot;2016-07-21 23:29:58&quot;,&quot;list&quot;:[{&quot;section&quot;:&quot;OA系统&quot;,&quot;selected&quot;:&quot;1&quot;,&quot;lists&quot;:[{&quot;name&quot;:&quot;签到系统&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;sign&quot;,&quot;selected&quot;:&quot;0&quot;},{&quot;name&quot;:&quot;工作计划&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;task&quot;,&quot;selected&quot;:&quot;0&quot;},{&quot;name&quot;:&quot;工作墙&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;jobwall&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;工作日志&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;performance&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;财务记录&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;charge&quot;,&quot;selected&quot;:&quot;1&quot;}]},{&quot;section&quot;:&quot;互动管理&quot;,&quot;selected&quot;:&quot;1&quot;,&quot;lists&quot;:[{&quot;name&quot;:&quot;会员列表&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;userlist&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;评论列表&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;commentlist&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;友链管理&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;friendlinklist&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;消息列表&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;messagelist&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;用户反馈&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;feedback&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;设备列表&quot;,&quot;type&quot;:&quot;link&quot;,&quot;content&quot;:&quot;devicelist&quot;,&quot;selected&quot;:&quot;1&quot;},{&quot;name&quot;:&quot;错误报告&quot;,&quot;type&quot;:&quot;link&quot;
        ///</summary>
        [Column("power")]
        public string Power { get; set; }
        
        /// <summary>
        /// 0->;非demo账号 1->;demo 账号 注意：demo账号的意思是，很多敏感权限将进行关闭，比如财务，项目，删除等操作。
        ///</summary>
         [Column("demo")]
        public int Demo { get; set; }

        /// <summary>
        /// 毕业院校
        ///</summary>
        [Column("graduate")]
        public string Graduate { get; set; }

        /// <summary>
        /// _user_roles id 对应
        ///</summary>
        [Column("roleid")]
        public int Roleid { get; set; }

        /// <summary>
        /// 
        ///</summary>
        [Column("refresh_time")]
        public int? RefreshTime { get; set; }
    }
}
