﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Siger.WeComApi.Core.Dto.Request
{
    public class RequestAddParameter
    {
        [Required(ErrorMessage = "NameIsEmpty")]
        public string name { get; set; }

        public string module { get; set; }

        public string type { get; set; }

        public string unit { get; set; } = string.Empty;

        public string category { get; set; }

        public string code { get; set; }

        public IEnumerable<RequestKeyValue> selectValue { get; set; }

        public string description { get; set; } = string.Empty;
    }


    public class RequestEditParameter : RequestAddParameter
    {
        public int id { get; set; }
    }
}
