﻿using Microsoft.EntityFrameworkCore;
using Siger.WeComApi.Core.Repository;
using System;
using System.Threading.Tasks;

namespace Siger.WeComApi.Repository
{
    public class UnitOfWork : IUnitOfWork
    {
        private readonly DbContext dbContext;

        public UnitOfWork(BaseDataDbContext baseDataDbContext)
        {
            this.dbContext = baseDataDbContext;
        }

        public int Commit()
        {
            try
            {
                var result = dbContext.SaveChanges();
                return result;
            }
            catch (Exception exception)
            {
                if (exception.InnerException != null)
                {
                    throw exception.InnerException;
                }
                throw;
            }
        }

        public Task<int> CommitAsync()
        {
            try
            {
                return dbContext.SaveChangesAsync();
            }
            catch (Exception exception)
            {
                if (exception.InnerException != null)
                {
                    throw exception.InnerException;
                }
                throw;
            }
        }
    }
}
