﻿

namespace Siger.WeComApi.Common.ExcelImport
{
    public class IncomingMaterialList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        public int No { get; set; }
        [ExcelColumn("物料编号")]
        public string MaterialPn { get; set; }
        [ExcelColumn("物料名称")]
        public string MaterialName { get; set; }
        [ExcelColumn("物料规格")]
        public string MaterialSpec { get; set; }
        [ExcelColumn("检验位置")]
        public string Section { get; set; }
        [ExcelColumn("供应商")]
        public string Supplier { get; set; }       
        [ExcelColumn("批次")]
        public string batchNumber { get; set; }
        [ExcelColumn("总数量")]
        public int TotalQuantity { get; set; }
        [ExcelColumn("检验数量")]
        public int RandomCheckNumber { get; set; }
        [ExcelColumn("结果(1->合格;2->返工;3->让步接收;4->拒收)")]
        public string Result { get; set; }        
        [ExcelColumn("检验人")]
        public string CheckUser { get; set; }
        [ExcelColumn("检验时间")]
        public string CheckTime { get; set; }
        [ExcelColumn("PO")]
        public string PO { get; set; }
        [ExcelColumn("备注")]
        public string Remark { get; set; }
        [ExcelColumn("到货时间")]
        public string ArrivalDate { get; set; }
    }

    public class IncomingMaterialDetailList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        public int No { get; set; }
        [ExcelColumn("二维码")]
        public string SN { get; set; }
        [ExcelColumn("项目")]
        public string Item { get; set; }
        [ExcelColumn("标准")]
        public string Standard { get; set; }
        [ExcelColumn("下限")]
        public string MinValue { get; set; }
        [ExcelColumn("上限")]
        public string MaxValue { get; set; }
        [ExcelColumn("标准极差")]
        public string Range { get; set; }
        [ExcelColumn("结果")]
        public string DetailResult { get; set; }
        [ExcelColumn("实际最小值")]
        public string LowerLimit { get; set; }
        [ExcelColumn("实际最大值")]
        public string UpperLimit { get; set; }
        [ExcelColumn("单值")]
        public string Value { get; set; }
        [ExcelColumn("实际极差")]
        public string ActualRange { get; set; }
    }
}
