﻿

namespace Siger.WeComApi.Common.ExcelImport
{
    public class SensorParameter : ImportBase
    {
        [ExcelColumn("传感器名称*")]
        public string name { get; set; }
        [ExcelColumn("传感器类型*")]
        public string type { get; set; }
        [ExcelColumn("厂牌")]
        public string factory_label { get; set; }
        [ExcelColumn("型号")]
        public string model { get; set; }
        [ExcelColumn("标定周期单位*")]
        public string cycle_unit_value { get; set; }
        [ExcelColumn("标定周期*")]
        public double cycle { get; set; }
        [ExcelColumn("标定提前通知*")]
        public int alarm { get; set; }
        [ExcelColumn("设备*")]
        public string machine { get; set; }
        [ExcelColumn("测量范围")]
        public string range { get; set; }
        [ExcelColumn("传感器状态*")]
        public string sensor_status { get; set; }
        [ExcelColumn("出厂精度")]
        public string factory_precision { get; set; }
        [ExcelColumn("实验可接受精度1*")]
        public string acceptable_precision1 { get; set; }
        [ExcelColumn("实验可接受精度2")]
        public string acceptable_precision2 { get; set; }
        [ExcelColumn("实验可接受精度3")]
        public string acceptable_precision3 { get; set; }
        [ExcelColumn("实验可接受精度4")]
        public string acceptable_precision4 { get; set; }
        [ExcelColumn("实验可接受精度5")]
        public string acceptable_precision5 { get; set; }
        [ExcelColumn("标定场所")]
        public string mark_place { get; set; }
        [ExcelColumn("外接系统")]
        public string external_system { get; set; }
        [ExcelColumn("内部标定手册")]
        public string bind_manual { get; set; }
        [ExcelColumn("内部验证手册")]
        public string validation_manual { get; set; }
        [ExcelColumn("标准规程一")]
        public string standard_procedure1 { get; set; }
        [ExcelColumn("标准规程二")]
        public string standard_procedure2 { get; set; }
        [ExcelColumn("要求温度")]
        public string temperature { get; set; }
        [ExcelColumn("备注")]
        public string remark { get; set; }
        [ExcelColumn("要求湿度")]
        public string humidity { get; set; }
        [ExcelColumn("应用工位")]
        public string position { get; set; }
        [ExcelColumn("质量体系(使用,隔开)*")]
        public string quality { get; set; }
        [ExcelColumn("校准源")]
        public string calibration_source { get; set; }
        [ExcelColumn("标准传感器1")]
        public string sensor1 { get; set; }
        [ExcelColumn("标准传感器2")]
        public string sensor2 { get; set; }
        [ExcelColumn("标准传感器3")]
        public string sensor3 { get; set; }
        [ExcelColumn("标准传感器4")]
        public string sensor4 { get; set; }
        [ExcelColumn("期间核查")]
        public string verification { get; set; }
        [ExcelColumn("标定人(工号)*")]
        public string mark_user { get; set; }
        [ExcelColumn("上次标定时间")]
        public string marktime { get; set; }
    }
    public class SensorMark : ImportBase
    {
        [ExcelColumn("传感器类别")]
        public string type { get; set; }
        [ExcelColumn("传感器编号")]
        public string sensor_code { get; set; }
        [ExcelColumn("传感器名称")]
        public string name { get; set; }
        [ExcelColumn("位置")]
        public string machine { get; set; }
        [ExcelColumn("结果")]
        public string result { get; set; }
        [ExcelColumn("标定人")]
        public string user { get; set; }
        [ExcelColumn("标定时间")]
        public string marktime { get; set; }
        [ExcelColumn("下次标定时间")]
        public string nextmarktime { get; set; }
        [ExcelColumn("当前状态")]
        public string state { get; set; }
        [ExcelColumn("倒计时")]
        public string resttime { get; set; }
    }
    public class SensorDetail : ImportBase
    {
        [ExcelColumn("传感器编号")]
        public string sensor_code { get; set; }
        [ExcelColumn("传感器名称")]
        public string name { get; set; }
        [ExcelColumn("传感器类别")]
        public string type { get; set; }
        [ExcelColumn("型号/序列号")]
        public string model { get; set; }
        [ExcelColumn("位置")]
        public string station { get; set; }
        [ExcelColumn("设备")]
        public string equipment { get; set; }
        [ExcelColumn("应用工位")]
        public string position { get; set; }
        [ExcelColumn("上次标定日期")]
        public string marktime { get; set; }
        [ExcelColumn("本次标定日期")]
        public string upload_time { get; set; }
        [ExcelColumn("下次标定时间")]
        public string nextmarktime { get; set; }
        [ExcelColumn("内部标定手册")]
        public string bind_manual { get; set; }
        [ExcelColumn("内部验证手册")]
        public string validation_manual { get; set; }
        [ExcelColumn("标准规程一")]
        public string standard_procedure1 { get; set; }
        [ExcelColumn("标准规程二")]
        public string standard_procedure2 { get; set; }
        [ExcelColumn("要求温度")]
        public string temperature { get; set; }
        [ExcelColumn("要求湿度")]
        public string humidity { get; set; }
        [ExcelColumn("实验可接受精度1")]
        public string acceptable_precision1 { get; set; }
        [ExcelColumn("实验可接受精度2")]
        public string acceptable_precision2 { get; set; }
        [ExcelColumn("实验可接受精度3")]
        public string acceptable_precision3 { get; set; }
        [ExcelColumn("实验可接受精度4")]
        public string acceptable_precision4 { get; set; }
        [ExcelColumn("实验可接受精度5")]
        public string acceptable_precision5 { get; set; }
        [ExcelColumn("校准源编号")]
        public string calibration_source { get; set; }
        [ExcelColumn("校准源名称")]
        public string calibration_source_name { get; set; }
        [ExcelColumn("校准源标定日期")]
        public string calibration_marktime { get; set; }
        [ExcelColumn("校准源下次标定日期")]
        public string calibration_nextmarktime { get; set; }
        [ExcelColumn("校准源测量范围")]
        public string calibration_range { get; set; }
        [ExcelColumn("校准源测量精度")]
        public string calibration_factory_precision { get; set; }
        [ExcelColumn("校准源报告")]
        public string calibration_file_name { get; set; }
        [ExcelColumn("标准传感器一编号")]
        public string sensor1_source { get; set; }
        [ExcelColumn("标准传感器一名称")]
        public string sensor1_source_name { get; set; }
        [ExcelColumn("标准传感器一标定日期")]
        public string sensor1_marktime { get; set; }
        [ExcelColumn("标准传感器一下次标定日期")]
        public string sensor1_nextmarktime { get; set; }
        [ExcelColumn("标准传感器一测量范围")]
        public string sensor1_range { get; set; }
        [ExcelColumn("标准传感器一测量精度")]
        public string sensor1_factory_precision { get; set; }
        [ExcelColumn("标准传感器一报告")]
        public string sensor1_file_name { get; set; }
        [ExcelColumn("标准传感器二编号")]
        public string sensor2_source { get; set; }
        [ExcelColumn("标准传感器二名称")]
        public string sensor2_source_name { get; set; }
        [ExcelColumn("标准传感器二标定日期")]
        public string sensor2_marktime { get; set; }
        [ExcelColumn("标准传感器二下次标定日期")]
        public string sensor2_nextmarktime { get; set; }
        [ExcelColumn("标准传感器二测量范围")]
        public string sensor2_range { get; set; }
        [ExcelColumn("标准传感器二测量精度")]
        public string sensor2_factory_precision { get; set; }
        [ExcelColumn("标准传感器二报告")]
        public string sensor2_file_name { get; set; }
        [ExcelColumn("标准传感器三编号")]
        public string sensor3_source { get; set; }
        [ExcelColumn("标准传感器三名称")]
        public string sensor3_source_name { get; set; }
        [ExcelColumn("标准传感器三标定日期")]
        public string sensor3_marktime { get; set; }
        [ExcelColumn("标准传感器三下次标定日期")]
        public string sensor3_nextmarktime { get; set; }
        [ExcelColumn("标准传感器三测量范围")]
        public string sensor3_range { get; set; }
        [ExcelColumn("标准传感器三测量精度")]
        public string sensor3_factory_precision { get; set; }
        [ExcelColumn("标准传感器三报告")]
        public string sensor3_file_name { get; set; }
        [ExcelColumn("标准传感器四编号")]
        public string sensor4_source { get; set; }
        [ExcelColumn("标准传感器四名称")]
        public string sensor4_source_name { get; set; }
        [ExcelColumn("标准传感器四标定日期")]
        public string sensor4_marktime { get; set; }
        [ExcelColumn("标准传感器四下次标定日期")]
        public string sensor4_nextmarktime { get; set; }
        [ExcelColumn("标准传感器四测量范围")]
        public string sensor4_range { get; set; }
        [ExcelColumn("标准传感器四测量精度")]
        public string sensor4_factory_precision { get; set; }
        [ExcelColumn("标准传感器四报告")]
        public string sensor4_file_name { get; set; }
        [ExcelColumn("标定文档")]
        public string file_name { get; set; }
        [ExcelColumn("标定通过")]
        public string bind_pass { get; set; }
        [ExcelColumn("标定通过警告")]
        public string bind_warn { get; set; }
        [ExcelColumn("标定不通过")]
        public string bind_notpass { get; set; }
        [ExcelColumn("不通过历史数据分析")]
        public string history_file { get; set; }
        [ExcelColumn("不通过选项")]
        public string history_result { get; set; }
        [ExcelColumn("外观无损坏")]
        public string appearance { get; set; }
        [ExcelColumn("标签完整")]
        public string label { get; set; }
        [ExcelColumn("标定备注")]
        public string remark { get; set; }
        [ExcelColumn("标定人")]
        public string user { get; set; }
        [ExcelColumn("审核人1")]
        public string checkuser { get; set; }
        [ExcelColumn("审核人2")]
        public string checkuser2 { get; set; }
        [ExcelColumn("批准人")]
        public string approvaluser { get; set; }
        [ExcelColumn("报告生成日期")]
        public string reporttime { get; set; }
        [ExcelColumn("报告名称")]
        public string reportname { get; set; }
        [ExcelColumn("历史结果报废")]
        public string history_scrap { get; set; }
        [ExcelColumn("历史结果维修")]
        public string history_reapir { get; set; }
        [ExcelColumn("历史结果让步接收")]
        public string history_accept { get; set; }
        [ExcelColumn("历史结果改变用途")]
        public string history_change { get; set; }
        [ExcelColumn("上次验证不通过")]
        public string lastvalidation_failed { get; set; }
        [ExcelColumn("上次标定报告名称")]
        public string lastvalidation_report { get; set; }
    }
}
