﻿

namespace Siger.WeComApi.Common.ExcelImport
{
    public class SparepartRecordList: ImportBase
    {
        [ExcelColumn("出入库编号")]
        public string RecordCode { get; set; }
        [ExcelColumn("编号")]
        public string Code { get; set; }
        [ExcelColumn("规格型号/图纸号")]
        public string Param { get; set; }
        [ExcelColumn("名称")]
        public string Name { get; set; }

        [ExcelColumn("出入库时间")]
        public string CreateTime { get; set; }

        [ExcelColumn("出入库类型")]
        public string IOType { get; set; }

        [ExcelColumn("维修工单/入库工单")]
        public string OrderCode { get; set; }

        [ExcelColumn("使用设备")]
        public string Location { get; set; }

        [ExcelColumn("领用人/入库人")]
        public string Operator { get; set; }

        [ExcelColumn("数量")]
        public double Number { get; set; }

        [ExcelColumn("单价")]
        public double Price { get; set; }

        [ExcelColumn("总价")]
        public double TotalPrice { get; set; }

        [ExcelColumn("当前库存")]
        public string Sku { get; set; }

        [ExcelColumn("经办人")]
        public string Creator { get; set; }

        [ExcelColumn("备注")]
        public string Remark { get; set; }
    }

    public class SparepartHistoryList : ImportBase
    {
        [ExcelColumn("序号")]
        public int No { get; set; }
        [ExcelColumn("备件编号")]
        public string Code { get; set; }
        [ExcelColumn("备件型号")]
        public string Param { get; set; }
        [ExcelColumn("成本目的")]
        public string Cost { get; set; }
        [ExcelColumn("领用时间")]
        public string UseTime { get; set; }
        [ExcelColumn("领用数量")]
        public double Number { get; set; }
        [ExcelColumn("领用人")]
        public string UseName { get; set; }
        [ExcelColumn("经办人")]
        public string OperateName { get; set; }
        [ExcelColumn("备注")]
        public string Remark { get; set; }
    }
}
