﻿using Siger.WeComApi.Core.Enum.ModuleEnum;

namespace Siger.WeComApi.Common.ExcelImport
{
    public class StockAccessOrderList : ImportBase
    {
        [ExcelColumn("*入库单号")]
        [EmptyValidate("StockNumIsEmpty")]
        public string StockNum { get; set; }

        [ExcelColumn("*入库类型")]
        [EmptyValidate("StockTypeIsEmpty")]
        public WaveHousingType StockType { get; set; }

        [ExcelColumn("*刀具料号")]
        [EmptyValidate("SNIsEmpty")]
        public string Pn { get; set; }

        [ExcelColumn("*仓库")]
        [EmptyValidate("WarehouseIsEmpty")]
        public string Warehouse { get; set; }

        [ExcelColumn("*储位")]
        [EmptyValidate("StorageIsEmpty")]
        public string Storage { get; set; }

        [ExcelColumn("*管理模式(序号，批次号)")]
        [EmptyValidate("ManagementModelIsEmpty")]
        public string ManagementModel { get; set; }

        [ExcelColumn("*序列号")]
        [EmptyValidate("SerialNumberIsEmpty")]
        public string SerialNumber { get; set; }

        [ExcelColumn("*入库数量")]
        [EmptyValidate("StockQuantityIsEmpty")]
        public int StockQuantity { get; set; }

        [ExcelColumn("*是否检测")]
        [EmptyValidate("IsTestIsEmpty")]
        public string IsTest { get; set; }

        [ExcelColumn("使用寿命")]
        public string UseLife { get; set; }

    }
}
