﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc.Filters;
using Microsoft.Extensions.Primitives;

namespace Siger.WeComApi.Common.Helpers
{
    public class HeadHelper
    {
        /// <summary>
        /// 获取Head 字段信息
        /// </summary>
        /// <param name="context"></param>
        /// <param name="key"></param>
        /// <returns></returns>
        public static string GetHead(HttpRequest request, string key)
        {
            var hasValue = request.Headers.TryGetValue(key, out StringValues value);
            if (hasValue)
            {
                return value;
            }
            return null;
        }
    }
}
