﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Siger.WeComApi.Core.Dto.Request
{
    public class RequestDeleteEntities
    {
        public IEnumerable<int> ids { get; set; }
    }

    public class RequestPrintRecords
    {
        public List<RequestPrint> Print { get; set; }
    }

    public class RequestPrint
    {
        /// <summary>
        /// 物料编号
        /// </summary>
        public string PN { get; set; }
        /// <summary>
        /// 批次
        /// </summary>
        public int batch { get; set; }
        /// <summary>
        /// 供应商邓白氏码
        /// </summary>
        public string supplier_code { get; set; }
        /// <summary>
        /// 生产日期
        /// </summary>
        public DateTime productionTime { get; set; }
        /// <summary>
        /// 追溯码
        /// </summary>
        public string trace_code { get; set; }
        /// <summary>
        /// 模具编号
        /// </summary>
        public string mould_code { get; set; }
        /// <summary>
        /// 钢材供应商邓白氏
        /// </summary>
        public string steel_supplier_code { get; set; }
        /// <summary>
        /// 热处理
        /// </summary>
        public string heat_treatment { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string remarks { get; set; }
        /// <summary>
        /// 钢路
        /// </summary>
        public string steel_road { get; set; }
        /// <summary>
        /// 二维码
        /// </summary>
        public string SN { get; set; }
        /// <summary>
        /// 数量
        /// </summary>
        public int quantity { get; set; }
        /// <summary>
        /// 打印数量
        /// </summary>
        public int printcount { get; set; }
        /// <summary>
        /// 重量
        /// </summary>
        public double weight { get; set; }
    }

    public class RequestPrintList
    {
        /// <summary>
        /// 物料名称
        /// </summary>
        public string name { get; set; }
        /// <summary>
        /// 物料规格
        /// </summary>
        public string spec { get; set; }
        /// <summary>
        /// 物料编号
        /// </summary>
        public string PN { get; set; }
        /// <summary>
        /// 批次
        /// </summary>
        public int batch { get; set; }
        /// <summary>
        /// 供应商邓白氏码
        /// </summary>
        public string supplier_code { get; set; }
        /// <summary>
        /// 生产日期
        /// </summary>
        public DateTime productionTime { get; set; }
        /// <summary>
        /// 追溯码
        /// </summary>
        public string trace_code { get; set; }
        /// <summary>
        /// 模具编号
        /// </summary>
        public string mould_code { get; set; }
        /// <summary>
        /// 钢材供应商邓白氏
        /// </summary>
        public string steel_supplier_code { get; set; }
        /// <summary>
        /// 热处理
        /// </summary>
        public string heat_treatment { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string remarks { get; set; }
        /// <summary>
        /// 钢路
        /// </summary>
        public string steel_road { get; set; }
        /// <summary>
        /// 二维码
        /// </summary>
        public string SN { get; set; }
        /// <summary>
        /// 操作人id
        /// </summary>
        public int mid { get; set; }

        /// <summary>
        /// 操作人
        /// </summary>
        public string username { get; set; }
        /// <summary>
        /// 操作时间
        /// </summary>
        public DateTime operationTime { get; set; }
        /// <summary>
        /// 数量
        /// </summary>
        public int quantity { get; set; }
        /// <summary>
        /// 打印数量
        /// </summary>
        public int printcount { get; set; }
        /// <summary>
        /// 重量
        /// </summary>
        public double weight { get; set; }
    }

    public class RequestScheduledDownTime
    {
        public int sectionID { get; set; }
        public string startTime { get; set; }
        public int frequency { get; set; }
    }

    public class RequestShiftList
    {
        public string  title { get; set; }
        public string startTime { get; set; }
        public string endTime { get; set; }
        public string duration { get; set; }
    }

    public class RequestShiftLists
    {
        public List<RequestShiftList> list { get; set; }
        public string timeOne { get; set; }
        public string timeTwo { get; set; }
    }
}
