﻿using Microsoft.EntityFrameworkCore;
using Siger.WeComApi.Common;
using Siger.WeComApi.Core.Domain;
using System;

namespace Siger.WeComApi.Repository
{
    public class BaseDataReadDbContext : BaseDBContext
    {
        static Random random = new Random();
        public BaseDataReadDbContext()
        {

        }

        public BaseDataReadDbContext(DbContextOptions<BaseDataReadDbContext> options) : base(options)
        {

        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            base.OnModelCreating(modelBuilder);
        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            var useOneDb = ConfigManager.GetValue("DbSetting", "UseOneDb", true);
            if (useOneDb)
            {
                var readDbCount = ConfigManager.GetValue("DbSetting", "readDbCount", 0);
                if (readDbCount > 0)
                {
                    int i = random.Next(1, readDbCount);
                    var connectionString = ConfigManager.GetValue("DbSetting", $"ReadDbConnection_{i}", string.Empty);
                    if (!string.IsNullOrEmpty(connectionString))
                    {
                        optionsBuilder.UseMySql(connectionString);
                    }
                }
            }
            else
            {
                var clusterConnection = ConfigManager.GetValue("DbClusterSetting", "ReadClusterConnection", string.Empty);
                if (!string.IsNullOrEmpty(clusterConnection))
                {
                    optionsBuilder.UseMySql(clusterConnection);
                }
            }
        }
    }
}
