﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace Siger.WeComApi.Core.Enum.ModuleEnum
{
    /// <summary>
    /// Tlm module, start from 8000000
    /// </summary>
    public enum TlmEnum
    {
        [Description("用户名或密码错误")]
        LoginError = 8000000,

        [Description("项目用户未找到")]
        ProjectUserNotFound,

        [Description("项目未找到")]
        ProjectNotFound,

        [Description("用户未设置线边柜")]
        StoragesNotFound,

        [Description("线边柜未找到")]
        StorageNotFound,

        [Description("参数异常")]
        ParameterError,

        [Description("称台已设置")]
        PlatformIsExist,

        [Description("称台信息未找到")]
        PlatformNotExist,

        [Description("设备信息未找到")]
        MachineNotExist,

        [Description("设备尚未维护刀位数")]
        MachineToolNotExist,

        [Description("设备安装信息未找到")]
        MachineInstallNotExist,

        [Description("料号未找到")]
        MaterialNotFound,

        [Description("刀具信息未找到")]
        ToolNotFound = 8100060,

        [Description("记录已存在")]
        RecordExist,

        [Description("刀具检验项目未找到")]
        RecordItemNotFound,
        [Description("刀柄信息未找到")]
        HandleNotFound,
        [Description("刀头信息未找到")]
        CutNotFound,
        [Description("附件信息未找到")]
        AttahmentNotFound,
        [Description("刀具测试信息未找到")]
        TestRecordNotFound,
        [Description("请检查必填项")]
        CheckRequiredFields,
        [Description("刀具检验项目已存在")]
        RecordItemExist,
        [Description("刀具号未找到")]
        ToolCodeNotFound,
        [Description("刀具已经安装,无法继续操作")]
        ToolInstalled,
        [Description("类型信息未找到")]
        CategoryNotFound,
        [Description("编码信息未找到")]
        NumberNotFound,
        [Description("刀柄不能大于2")]
        HandleNoMore,
        [Description("检测类型没有维护")]
        DetectionTypeError,

        [Description("该备刀清单已经完成")]
        OrderChoiceComplated,
        [Description("修模已经完成")]
        GrindComplated,
        [Description("修模状态已改变")]
        GrindStatusChanged,
        [Description("BOM 已存在")]
        BomCodeExits,
        [Description("BOM 刀具不完整")]
        ToolConfigMissing,
        [Description("BOM 刀具数量不正确")]
        ToolConfigCntErro,
        [Description("刀柄已经存在其他Package中")]
        PackageAssembed,
        [Description("组装信息不存在")]
        PackageNotAssem,
        [Description("没有安装信息")]
        NoInstallInfo,
        [Description("未找到刀具申请信息")]
        ToolChoiceSummaryEmtpy,
        [Description("Package已经安装")]
        PackageInstalled,
        [Description("Package没有测量信息")]
        PackageMeasureNull,
        [Description("刀补信息写入失败")]
        ToolWriteFail,
        [Description("刀具检测顺序错误")]
        ToolDetechtionNotfound,
        [Description("刀具检测不通过")]
        ToolDetechResultNg,
        [Description("刀具测试流程未完成")]
        ToolInComplete,
        [Description("该刀位正在使用中")]
        ToolLocationNotFree,
        [Description("检测或测试通过的物料不能退货")]
        ToolReturnOnlyFail

    }
    /// <summary>
    /// 刀具柜结算状态
    /// </summary>
    public enum CabinetReceiveStatus
    {
        /// <summary>
        /// 关闭
        /// </summary>
        [Description("关闭")]
        Closed = 0,

        /// <summary>
        /// 未结算
        /// </summary>
        [Description("未结算")]
        NoSettlement = 1,

        /// <summary>
        /// 结算
        /// </summary>
        [Description("结算")]
        Settlement = 2,

        /// <summary>
        /// 待结算
        /// </summary>
        [Description("待结算")]
        WaitSettlement = 3
    }
    /// <summary>
    /// 刀具卸载原因
    /// </summary>
    public enum UninstallReason
    {
        [Description("断刀")]
        Broken = 1,
        [Description("崩刃")]
        Damage,
        [Description("磨损")]
        Collapse,
        [Description("寿命到期")]
        EndLife,
        [Description("其他原因")]
        Other,
    }
    //1 Inactive 2 Ready 3 Running 4 Stopped 5 Currently resetting 6 A part program is compiled and checked 7 Errors
    public enum ChannelState
    {
        Inactive = 1,
        Ready,
        Running,
        Stopped,
        CurrentlyResetting,
        APartProgramIsCompiledAndChecked,
        Errors
    }
}
