﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Core.Domain.BigData.Models
{
    public class MachineData
    {
        public string machine_name { get; set; }

        public int machine_id { get; set; }

        public string machine_code { get; set; }

        public int section_id { get; set; }

        public string lastSectionTitle { get; set; }

        public string lastSecondSectionTitle { get; set; }

        public int lastSecondSectionId { get; set; }

        public int sorting { get; set; } = 0;
        //Dashboard控制器得GetSectionTreeForDashboard需要查非nc得
        public int category { get; set; }

        /// <summary>
        /// 真实的倒数第二级
        /// </summary>
        public string reallastSecondSectionTitle { get; set; }

        public int CompanyId { get; set; }
        public int ProjectId { get; set; }

        /// <summary>
        /// 设备型号
        /// </summary>
        public string MachineModel { get; set; }

        /// <summary>
        /// 机床序列号
        /// </summary>
        public string MachineToolCode { get; set; }

        /// <summary>
        /// 设备区域
        /// </summary>
        public string County { get; set; }

        /// <summary>
        /// 工厂名称
        /// </summary>
        public string FactoryName { get; set; }

        /// <summary>
        /// 父级设备类型
        /// </summary>
        public int ParentMachineType { get; set; }

        /// <summary>
        /// 设备类型
        /// </summary>
        public int MachineType { get; set; }

        /// <summary>
        /// 省份
        /// </summary>
        public string Province { get; set; }

        /// <summary>
        /// 市
        /// </summary>
        public string City { get; set; }


        ///<summary>
		/// 父级设备类型
		/// </summary>
        public string ParentMachinetype { get; set; }
        /// <summary>
        /// 设备类型
        /// </summary>
        public string MachineTypeName { get; set; }
        /// <summary>
        /// 机床序列号
        /// </summary>
        public string MachineSerialnum { get; set; }
        /// <summary>
        /// 盒子编号
        /// </summary>
        public string BoxNumber { get; set; }
        /// <summary>
        /// 控制系统型号
        /// </summary>
        public string ControllerModel { get; set; }

        /// <summary>
        /// 设备创建时期
        /// </summary>
        public DateTime MachineTime { get; set; }

        /// <summary>
		/// 设备联网时间
		/// </summary>
        public DateTime? NetworkTime { get; set; }

        /// <summary>
        /// 工厂id
        /// </summary>
        public int FactoryId { get; set; }
    }

    public class MachineToolData
    {
        public string machine_name { get; set; }

        public int machine_id { get; set; }

        public string machine_code { get; set; }
    }

    public class MachineIds
    {
        public int machine_id { get; set; }
    }

    public class MachineAppData:MachineIds
    {
        public string lastSectionTitle { get; set; }

        public string lastSecondSectionTitle { get; set; }

        public string machineName { get; set; }
    }
}
