﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.Text;

namespace Siger.WeComApi.Core.Domain.Entity
{
    /// <summary>
    /// 项目注册实体
    /// </summary>
    [Table("siger_company_project_register")]
    public class siger_company_project_register : ConfigEntityBase
    {
        /// <summary>
        /// 注册guid
        /// </summary>
        [Column("registerguid")]
        public string registerguid { get; set; }
        /// <summary>
        /// 企业编号
        /// </summary>
        [Column("companyid")]
        public int companyid { get; set; }
        /// <summary>
        /// 项目编号
        /// </summary>
        [Column("projectid")]
        public int projectid { get; set; }
        /// <summary>
        /// 项目账号id
        /// </summary>
        [Column("dutymid")]
        public int dutymid { get; set; }
        /// <summary>
        /// 步骤 1：客户资料，2：项目资料，3：产线层级，4：DNC服务配置，5：完成
        /// </summary>
        [Column("step")]
        public int step { get; set; }
        /// <summary>
        /// 注册状态 1 未注册，2 注册中，3 已注册
        /// </summary>
        [Column("registerstatus")]
        public int registerstatus { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        [Column("createtime")]
        public long createtime { get; set; }
        /// <summary>
        /// 创建人id
        /// </summary>
        [Column("creator")]
        public int creator { get; set; }
        /// <summary>
        /// 修改时间
        /// </summary>
        [Column("updatetime")]
        public long updatetime { get; set; }
        /// <summary>
        /// 修改人id
        /// </summary>
        [Column("updator")]
        public int updator { get; set; }

    }
}
